/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.pingdom.services;

import com.google.gson.reflect.TypeToken;
import com.jakewharton.pingdom.PingdomApiBuilder;
import com.jakewharton.pingdom.PingdomApiService;
import com.jakewharton.pingdom.entities.RawResults;
import com.jakewharton.pingdom.enumerations.StateStatus;
import java.util.Date;
import java.util.List;

public class ResultsService
extends PingdomApiService {
    public GetBuilder get(int checkId) {
        return new GetBuilder(this, checkId);
    }

    public static final class GetBuilder
    extends PingdomApiBuilder<RawResults> {
        private static final String PARAM_TO = "to";
        private static final String PARAM_FROM = "from";
        private static final String PARAM_PROBES = "probes";
        private static final String PARAM_STATUS = "status";
        private static final String PARAM_LIMIT = "limit";
        private static final String PARAM_OFFSET = "offset";
        private static final String PARAM_INCLUDE_ANALYSIS = "includeanalysis";
        private static final String FIELD_CHECK_ID = "checkid";
        private static final String URI = "/results/{checkid}";
        private static final int MAX_OFFSET = 432000;

        private GetBuilder(ResultsService service, int checkId) {
            super(service, new TypeToken<RawResults>(){}, URI);
            this.field(FIELD_CHECK_ID, checkId);
        }

        public GetBuilder to(Date to) {
            this.parameter(PARAM_TO, to);
            return this;
        }

        public GetBuilder from(Date from) {
            this.parameter(PARAM_FROM, from);
            return this;
        }

        public GetBuilder probes(List<Integer> probes) {
            this.parameter(PARAM_PROBES, probes);
            return this;
        }

        public GetBuilder status(List<StateStatus> statuses) {
            this.parameter(PARAM_STATUS, statuses);
            return this;
        }

        public GetBuilder limit(int limit) {
            this.parameter(PARAM_LIMIT, limit);
            return this;
        }

        public GetBuilder offset(int offset) {
            if (offset > 432000) {
                throw new IllegalArgumentException("Offset must be less than or equal to 432000");
            }
            this.parameter(PARAM_OFFSET, offset);
            return this;
        }

        public GetBuilder includeAnalysis(boolean includeAnalysis) {
            this.parameter(PARAM_INCLUDE_ANALYSIS, includeAnalysis);
            return this;
        }
    }
}

