/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.pingdom.services;

import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.jakewharton.pingdom.PingdomApiBuilder;
import com.jakewharton.pingdom.PingdomApiService;
import com.jakewharton.pingdom.entities.Message;
import com.jakewharton.pingdom.entities.Settings;
import com.jakewharton.pingdom.enumerations.PublicReportMonths;

public class SettingsService
extends PingdomApiService {
    public GetBuilder get() {
        return new GetBuilder(this);
    }

    public ModifyBuilder modify() {
        return new ModifyBuilder(this);
    }

    public static final class ModifyBuilder
    extends PingdomApiBuilder<Message> {
        private static final String POST_FIRST_NAME = "firstname";
        private static final String POST_LAST_NAME = "lastname";
        private static final String POST_COMPANY = "company";
        private static final String POST_EMAIL = "email";
        private static final String POST_CELL_PHONE = "cellphone";
        private static final String POST_CELL_COUNTRY_CODE = "cellcountrycode";
        private static final String POST_CELL_COUNTRY_ISO = "cellcountryiso";
        private static final String POST_PHONE = "phone";
        private static final String POST_PHONE_COUNTRY_CODE = "phonecountrycode";
        private static final String POST_PHONE_COUNTRY_ISO = "phonecountryiso";
        private static final String POST_ADDRESS = "address";
        private static final String POST_ADDRESS_2 = "address2";
        private static final String POST_ZIP = "zip";
        private static final String POST_LOCATION = "location";
        private static final String POST_STATE = "state";
        private static final String POST_AUTO_LOGOUT = "autologout";
        private static final String POST_REGION_ID = "regionid";
        private static final String POST_TIME_ZONE_ID = "timezoneid";
        private static final String POST_DATE_TIME_FORMAT_ID = "datetimeformatid";
        private static final String POST_NUMBER_FORMAT_ID = "numberformatid";
        private static final String POST_PUBLIC_REPORT_CUSTOM_DESIGN = "pubrcustomdesign";
        private static final String POST_PUBLIC_REPORT_TEXT_COLOR = "pubrtextcolor";
        private static final String POST_PUBLIC_REPORT_BACKGROUND_COLOR = "pubrbackgroundcolor";
        private static final String POST_PUBLIC_REPORT_LOGO_URL = "pubrlogourl";
        private static final String POST_PUBLIC_REPORT_MONTHS = "pubrmonths";
        private static final String POST_PUBLIC_REPORT_SHOW_OVERVIEW = "pubrshowoverview";
        private static final String POST_PUBLIC_REPORT_CUSTOM_DOMAIN = "pubrcustomdomain";
        private static final String URI = "/settings";

        private ModifyBuilder(SettingsService service) {
            super((PingdomApiService)service, new TypeToken<Message>(){}, URI, PingdomApiBuilder.HttpMethod.Put);
        }

        public ModifyBuilder firstName(String firstName) {
            this.postParameter(POST_FIRST_NAME, firstName);
            return this;
        }

        public ModifyBuilder lastName(String lastName) {
            this.postParameter(POST_LAST_NAME, lastName);
            return this;
        }

        public ModifyBuilder company(String company) {
            this.postParameter(POST_COMPANY, company);
            return this;
        }

        public ModifyBuilder email(String email) {
            this.postParameter(POST_EMAIL, email);
            return this;
        }

        public ModifyBuilder cellPhone(String cellPhone) {
            this.postParameter(POST_CELL_PHONE, cellPhone);
            return this;
        }

        public ModifyBuilder cellCountryCode(String cellCountryCode) {
            this.postParameter(POST_CELL_COUNTRY_CODE, cellCountryCode);
            return this;
        }

        public ModifyBuilder cellCountryIso(String cellCountryIso) {
            this.postParameter(POST_CELL_COUNTRY_ISO, cellCountryIso);
            return this;
        }

        public ModifyBuilder phone(String phone) {
            this.postParameter(POST_PHONE, phone);
            return this;
        }

        public ModifyBuilder phoneCountryCode(String phoneCountryCode) {
            this.postParameter(POST_PHONE_COUNTRY_CODE, phoneCountryCode);
            return this;
        }

        public ModifyBuilder phoneCountryIso(String phoneCountryIso) {
            this.postParameter(POST_PHONE_COUNTRY_ISO, phoneCountryIso);
            return this;
        }

        public ModifyBuilder address(String address) {
            this.postParameter(POST_ADDRESS, address);
            return this;
        }

        public ModifyBuilder address2(String address2) {
            this.postParameter(POST_ADDRESS_2, address2);
            return this;
        }

        public ModifyBuilder zip(String zip) {
            this.postParameter(POST_ZIP, zip);
            return this;
        }

        public ModifyBuilder location(String location) {
            this.postParameter(POST_LOCATION, location);
            return this;
        }

        public ModifyBuilder state(String state) {
            this.postParameter(POST_STATE, state);
            return this;
        }

        public ModifyBuilder autoLogout(boolean autoLogout) {
            this.postParameter(POST_AUTO_LOGOUT, autoLogout);
            return this;
        }

        public ModifyBuilder regionId(int regionId) {
            this.postParameter(POST_REGION_ID, regionId);
            return this;
        }

        public ModifyBuilder timeZoneId(int timeZoneId) {
            this.postParameter(POST_TIME_ZONE_ID, timeZoneId);
            return this;
        }

        public ModifyBuilder dateTimeFormatId(int dateTimeFormatId) {
            this.postParameter(POST_DATE_TIME_FORMAT_ID, dateTimeFormatId);
            return this;
        }

        public ModifyBuilder numberFormatId(int numberFormatId) {
            this.postParameter(POST_NUMBER_FORMAT_ID, numberFormatId);
            return this;
        }

        public ModifyBuilder publicReportCustomDesign(boolean publicReportCustomDesign) {
            this.postParameter(POST_PUBLIC_REPORT_CUSTOM_DESIGN, publicReportCustomDesign);
            return this;
        }

        public ModifyBuilder publicReportTextColor(String publicReportTextColor) {
            this.postParameter(POST_PUBLIC_REPORT_TEXT_COLOR, publicReportTextColor);
            return this;
        }

        public ModifyBuilder publicReportBackgroundColor(String publicReportBackgroundColor) {
            this.postParameter(POST_PUBLIC_REPORT_BACKGROUND_COLOR, publicReportBackgroundColor);
            return this;
        }

        public ModifyBuilder publicReportLogoUrl(String publicReportLogoUrl) {
            this.postParameter(POST_PUBLIC_REPORT_LOGO_URL, publicReportLogoUrl);
            return this;
        }

        public ModifyBuilder publicReportMonths(PublicReportMonths publicReportsMonths) {
            this.postParameter(POST_PUBLIC_REPORT_MONTHS, publicReportsMonths);
            return this;
        }

        public ModifyBuilder publicReportShowOverview(boolean publicReportsShowOverview) {
            this.postParameter(POST_PUBLIC_REPORT_SHOW_OVERVIEW, publicReportsShowOverview);
            return this;
        }

        public ModifyBuilder publicReportCustomDomain(String publicReportsCustomDomain) {
            this.postParameter(POST_PUBLIC_REPORT_CUSTOM_DOMAIN, publicReportsCustomDomain);
            return this;
        }
    }

    public static final class GetBuilder
    extends PingdomApiBuilder<Settings> {
        private static final String URI = "/settings";

        private GetBuilder(SettingsService service) {
            super(service, new TypeToken<Settings>(){}, URI);
        }

        @Override
        protected JsonElement execute() {
            return super.execute().getAsJsonObject().get("settings");
        }
    }
}

