/*
 * Copyright 2002-2021 Dr. Jalal Kiswani. 
 * Email: Kiswanij@Gmail.com
 * Check out https://smart-api.com for more details
 * 
 * All the opensource projects of Dr. Jalal Kiswani are free for personal and academic use only, 
 * for commercial usage and support, please contact the author.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jk.webstack.controllers;

import javax.annotation.PostConstruct;

import com.jk.data.dataaccess.JKDataAccessFactory;
import com.jk.data.dataaccess.core.JKDataAccessService;

// TODO: Auto-generated Javadoc
/**
 * The Class JKDbManagedBean.
 *
 * @author Jalal Kiswani
 */
public class JKManagedBeanWithSqlDataAccess extends JKAppBaseManagedBean {

	/** The data access. */
	protected JKDataAccessService sqlDataAccess = JKDataAccessFactory.getDataAccessService();

	/**
	 * Execute.
	 *
	 * @param query  the query
	 * @param params the params
	 */
	protected void execute(final String query, final Object... params) {
		this.sqlDataAccess.execute(query, params);
	}
	
	/**
	 * Gets the sql data access.
	 *
	 * @return the sql data access
	 */
	public JKDataAccessService getSqlDataAccess() {
		return sqlDataAccess;
	}

	/**
	 * Inits the.
	 */
	@PostConstruct
	public void init() {
	}

	
}
