/*
 * Copyright 2002-2021 Dr. Jalal Kiswani. 
 * Email: Kiswanij@Gmail.com
 * Check out https://smart-api.com for more details
 * 
 * All the opensource projects of Dr. Jalal Kiswani are free for personal and academic use only, 
 * for commercial usage and support, please contact the author.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jk.webstack.listeners;
/*

 * Copyright 2002-2019 Jalal Kiswani. 
 * E-mail: Kiswanij@Gmail.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;

import com.jk.core.config.JKConfig;
import com.jk.core.logging.JKLogger;
import com.jk.core.logging.JKLoggerFactory;
import com.jk.core.util.JK;
import com.jk.data.dataaccess.JKDataAccessFactory;
import com.jk.web.monitoring.JKMonitorService;
import com.jk.webstack.services.mointor.JKWebStackMonitor;

// TODO: Auto-generated Javadoc
/**
 * The listener interface for receiving JKContext events. The class that is
 * interested in processing a JKContext event implements this interface, and the
 * object created with that class is registered with a component using the
 * component. When the JKContext event occurs, that object's appropriate method
 * is invoked.
 *
 * @see JKWebstackContextEvent
 */
@WebListener
public class JKWebstackContextListener implements ServletContextListener {

	/** The logger. */
	JKLogger logger = JKLoggerFactory.getLogger(getClass());

	/** The initazlied. */
	static boolean initazlied;

	/**
	 * Inits the.
	 */
	public void init() {
		logger.debug("JKApplicationContextListener is initialied");
	}

	/**
	 * Context initialized.
	 *
	 * @param event the event
	 */
	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.servlet.ServletContextListener#contextInitialized(javax.servlet.
	 * ServletContextEvent)
	 */
	@Override
	public void contextInitialized(ServletContextEvent event) {
//		JKDataAccessFactory.init();
//		JK.runAsync(() -> {
			JKConfig.getDefaultInstance();// force init jk config if not configured
			JKMonitorService.setInstance(new JKWebStackMonitor());
//		});
//		String multiTenant = event.getServletContext().getInitParameter("jk.multi-tenant");
//		if (multiTenant != null && JKConversionUtil.toBoolean(multiTenant)) {
//			logger.info("Multi-tenant is enabled by context paramter");
//			JK.setMultiTenantApp(true);
//		}
		logger.info("contextInitialized");
	}

	/**
	 * Context destroyed.
	 *
	 * @param sce the sce
	 */
	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.servlet.ServletContextListener#contextDestroyed(javax.servlet.
	 * ServletContextEvent)
	 */
	@Override
	public void contextDestroyed(ServletContextEvent sce) {
		JKDataAccessFactory.getDefaultDataSource().close();
		logger.debug("contextDestroyed");
	}

}
