/*
 * Copyright 2002-2021 Dr. Jalal Kiswani. 
 * Email: Kiswanij@Gmail.com
 * Check out https://smart-api.com for more details
 * 
 * All the opensource projects of Dr. Jalal Kiswani are free for personal and academic use only, 
 * for commercial usage and support, please contact the author.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jk.webstack.rest;

import java.util.List;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.jk.core.jpa.BaseEntity;
import com.jk.core.util.JK;
import com.jk.core.util.JKObjectUtil;
import com.jk.data.dataaccess.JKDataAccessFactory;
import com.jk.data.dataaccess.orm.JKObjectDataAccess;

// TODO: Auto-generated Javadoc
/**
 * The Class JKMatureJpaRestService.
 *
 * @param <T> the generic type
 */
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public class JKMatureJpaRestService<T extends BaseEntity> {
	
	/** The da. */
	JKObjectDataAccess da = JKDataAccessFactory.getObjectDataAccessService();
	
	/** The clas. */
	private Class<T> clas;

	/**
	 * Instantiates a new JK mature jpa rest service.
	 */
	public JKMatureJpaRestService() {
		this.clas=JKObjectUtil.getGenericClassFromParent(this);
		if(this.clas==null) {
			JK.exception("Generic Class must provided in subclass");
		}
	}
	
	/**
	 * Gets the.
	 *
	 * @return the response
	 */
	@GET
	public Response get() {
		List<T> stacks = da.getList(clas);
		return Response.status(200).entity(stacks).build();
	}

	/**
	 * Gets the.
	 *
	 * @param id the id
	 * @return the response
	 */
	@GET
	@Path("/{id}")
	public Response get(@PathParam("id") String id) {
		T stack = da.find(clas,id);
		if (stack != null) {
			return Response.status(200).entity(stack).build();
		}
		return Response.status(404).build();
	}

	/**
	 * Adds the.
	 *
	 * @param stack the stack
	 * @return the response
	 */
	@POST
	public Response add(T stack) {
		da.insert(stack);
		return Response.status(201).entity(stack).build();
	}

	/**
	 * Update.
	 *
	 * @param id the id
	 * @param stack the stack
	 * @return the response
	 */
	@PUT
	@Path("/{id}")
	public Response update(@PathParam("id") String id, T stack) {
		if (da.find(clas,id) != null) {
			da.update(stack);
			return Response.status(201).entity(stack).build();
		}
		return Response.status(404).build();
	}

	/**
	 * Delete.
	 *
	 * @param id the id
	 * @return the response
	 */
	@DELETE
	@Path("/{id}")
	public Response delete(@PathParam("id") String id) {
		// Add validation and authorization that youa re the owner
		if (da.find(clas,id) != null) {
			da.delete(clas,id);
			return Response.status(201).build();
		}
		return Response.status(404).build();
	}

}
