/*
 * Copyright 2002-2021 Dr. Jalal Kiswani. 
 * Email: Kiswanij@Gmail.com
 * Check out https://smart-api.com for more details
 * 
 * All the opensource projects of Dr. Jalal Kiswani are free for personal and academic use only, 
 * for commercial usage and support, please contact the author.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jk.webstack.services.logging;

import java.util.Date;

import com.jk.data.dataaccess.JKDataAccessFactory;
import com.jk.data.dataaccess.core.JKDataAccessImpl;
import com.jk.data.dataaccess.core.JKDataAccessService;
import com.jk.data.dataaccess.orm.JKObjectDataAccess;
import com.jk.data.dataaccess.orm.JKObjectDataAccessImpl;
import com.jk.data.exceptions.JKRecordNotFoundException;

// TODO: Auto-generated Javadoc
/**
 * The Class ActionLogsService.
 */
public class ActionLogsService {
	
	/** The data access impl. */
	JKDataAccessService dataAccessImpl = JKDataAccessFactory.getDataAccessService();
	
	/** The object data access. */
	JKObjectDataAccess objectDataAccess = JKDataAccessFactory.getObjectDataAccessService();

	/**
	 * Log action.
	 *
	 * @param statType the stat type
	 */
	public void logAction(String statType) {
		try {
			dataAccessImpl.executeUpdate("UPDATE app_action_logs SET log_count=log_count+1 WHERE log_type=?", statType);
		} catch (JKRecordNotFoundException e) {
			dataAccessImpl.executeUpdate("INSERT INTO app_action_logs(log_type,log_count) VALUES(?,1)", statType);
		} catch (Exception e) {
			// just eat the exception for now
			e.printStackTrace();
		}
	}

	/**
	 * Gets the action log count.
	 *
	 * @param logType the log type
	 * @return the action log count
	 */
	public int getActionLogCount(String logType) {
		return dataAccessImpl.executeQueryAsInteger("SELECT log_count FROM app_action_logs WHERE log_type=?", logType);
	}

	/**
	 * Log user action.
	 *
	 * @param className the class name
	 * @param actionName the action name
	 * @param userName the user name
	 */
	public void logUserAction(String className, String actionName, String userName) {
		UserActionLog log = new UserActionLog();
		log.setLogClass(className);
		log.setLogType(actionName);
		log.setUserName(userName);
		log.setTime(new Date());
		objectDataAccess.insert(log);
	}
}
