/*
 * Copyright 2002-2021 Dr. Jalal Kiswani. 
 * Email: Kiswanij@Gmail.com
 * Check out https://smart-api.com for more details
 * 
 * All the opensource projects of Dr. Jalal Kiswani are free for personal and academic use only, 
 * for commercial usage and support, please contact the author.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.jk.webstack.services.mointor;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.exception.ExceptionUtils;

import com.jk.core.logging.JKLogger;
import com.jk.core.logging.JKLoggerFactory;
import com.jk.core.util.JK;
import com.jk.data.dataaccess.JKDataAccessFactory;
import com.jk.web.monitoring.JKMonitorService;

// TODO: Auto-generated Javadoc
/**
 * The Class JKWebStackMonitor.
 */
public class JKWebStackMonitor extends JKMonitorService {

	/** The logger. */
	JKLogger logger = JKLoggerFactory.getLogger(getClass());

	/** The service available. */
	private boolean serviceAvailable;

	/**
	 * Instantiates a new JK web stack monitor.
	 */
	public JKWebStackMonitor() {
		logger.info("Initialized");
		serviceAvailable = JKDataAccessFactory.isEntityAvailable(Event.class);
		if (!serviceAvailable) {
			logger.info(
					"Exceptions will not be logged into DB, add (com.jk.webstack.services.mointor) to your config.properties under (db-entities-packages) section");
		}
	}

	/**
	 * Publish.
	 *
	 * @param request   the request
	 * @param exception the exception
	 */
	@Override
	public void publish(HttpServletRequest request, Throwable exception) {
		JK.fixMe("Make it async");
		if (serviceAvailable) {
			try {
				String name = exception.getMessage();
				if (name.length() > 255) {
					name = name.substring(0, 255);
				}
				String userName = getUserName(request);
				logger.debug("Publishing Exception ({}) for user ({})", exception.getMessage(), userName);
				Event e = new Event();
				e.setEventType("Exception");
				e.setCrtUser(userName);
				e.setName(name);
				e.setEventText(ExceptionUtils.getStackTrace(exception));
				JKDataAccessFactory.getObjectDataAccessService().insert(e);
			} catch (Exception e) {
				logger.error("Failed to publish error: "+exception.getMessage()+" , for the following reason: "+e.getMessage());
			}
		}
	}
}
