package com.jk.webstack.services.workflow;

import java.util.List;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.bean.ViewScoped;

import com.jk.core.util.JK;
import com.jk.core.util.JKCollectionUtil;
import com.jk.core.util.JKObjectUtil;
import com.jk.services.client.workflow.JKWorkflowServiceClient;
import com.jk.services.client.workflow.models.PayloadModel;
import com.jk.web.faces.mb.JKManagedBean;

@ViewScoped
@ManagedBean(name = "workflow")
public class WorkflowController extends JKManagedBean {
	private PayloadModel payload;
	private List filterList2;
	JKWorkflowServiceClient client = new JKWorkflowServiceClient();
	private List<PayloadModel> payLoads;

	public List<PayloadModel> getPayloads() {
		if (payLoads == null) {
			payLoads = client.getPayLoads(JK.getAppName(), JKCollectionUtil.toString(getRoles(), false));
		}
		return payLoads;
	}

	public PayloadModel getPayload() {
		return payload;
	}

	/**
	 * @param id
	 * @return
	 */
	public String approvePayload(String entityName, int id) {
		return null;
	}

	public String rejectPayload(String entityName, int id) {
		String rejectAction = client.rejectWorkflowEntity(id);
		return null;
	}

	public PayloadModel findPayload(int id) {
		for (PayloadModel payload : getPayloads()) {
			if (payload.getId().equals(id)) {
				return payload;
			}
		}
		return null;
	}

	public List getFilterList2() {
		return filterList2;
	}

	public void setFilterList2(List filterList2) {
		this.filterList2 = filterList2;
	}
	
	public void reset() {
		this.payload=null;
		this.filterList2=null;
		this.payload=null;
		this.payLoads=null;
	}
	
}
