/*
 * Decompiled with CFR 0.152.
 */
package com.jk.webstack.controllers;

import com.jk.web.faces.mb.JKManagedBean;
import com.jk.webstack.services.email.EmailService;
import com.jk.webstack.services.logging.ActionLogsService;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.representations.IDToken;

public class JKAppBaseManagedBean
extends JKManagedBean {
    public String getUserName() {
        IDToken idToken = this.getIdToken();
        if (idToken == null) {
            return null;
        }
        return idToken.getPreferredUsername();
    }

    public String getFirstName() {
        IDToken idToken = this.getIdToken();
        if (idToken == null) {
            return null;
        }
        return idToken.getGivenName();
    }

    public String getFamilyName() {
        IDToken idToken = this.getIdToken();
        if (idToken == null) {
            return null;
        }
        return idToken.getFamilyName();
    }

    public String getEmail() {
        IDToken idToken = this.getIdToken();
        if (idToken == null) {
            return null;
        }
        return idToken.getEmail();
    }

    public IDToken getIdToken() {
        KeycloakPrincipal userPrincipal = (KeycloakPrincipal)this.request().getUserPrincipal();
        if (userPrincipal == null) {
            return null;
        }
        KeycloakPrincipal kp = userPrincipal;
        IDToken idToken = kp.getKeycloakSecurityContext().getIdToken();
        return idToken;
    }

    public boolean isUserLoggedIn() {
        return this.getUserName() != null;
    }

    public void logAction(String logType) {
        String className = this.getActionLogName();
        String actionName = logType;
        boolean userLoggedIn = this.isUserLoggedIn();
        String userName = this.getUserName();
        Runnable command = () -> {
            this.logger.info("Adding new logAction(type)", new Object[0]);
            this.getActionLogService().logAction(actionName);
            if (userLoggedIn) {
                this.getActionLogService().logUserAction(className, actionName, userName);
            }
        };
        this.executeAsyc(command);
    }

    protected String getActionLogName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected ActionLogsService getActionLogService() {
        return new ActionLogsService();
    }

    protected EmailService getEmailService() {
        return new EmailService();
    }
}

