/*
 * Decompiled with CFR 0.152.
 */
package com.jk.webstack.controllers;

import com.jk.core.factory.JKFactory;
import com.jk.core.test.JKMockUtil;
import com.jk.core.util.JK;
import com.jk.core.util.JKCollectionUtil;
import com.jk.core.util.JKObjectUtil;
import com.jk.data.dataaccess.orm.JKObjectDataAccess;
import com.jk.data.dataaccess.orm.JKObjectDataAccessImpl;
import com.jk.services.client.workflow.JKWorkflowServiceClient;
import com.jk.services.client.workflow.JKWorkflowUtil;
import com.jk.services.client.workflow.models.NewPayloadRequestModel;
import com.jk.services.client.workflow.models.PayloadModel;
import com.jk.services.client.workflow.models.WorkflowEntityModel;
import com.jk.webstack.controllers.ControllerMode;
import com.jk.webstack.controllers.JKManagedBeanWithSqlDataAccess;
import com.jk.webstack.services.workflow.WorkflowController;
import java.util.List;

public abstract class JKManagedBeanWithOrmSupport<T>
extends JKManagedBeanWithSqlDataAccess {
    private T model;
    private T original;
    private Class<T> modelClass;
    private List<T> modelList;
    private List<T> filterList;
    private List filterList2;
    private boolean alwaysRefreshList;
    protected ControllerMode mode;
    private boolean confirmReeset;
    boolean editTabular;
    JKWorkflowServiceClient client = new JKWorkflowServiceClient();
    boolean workflowAvialable;
    PayloadModel payload;
    List<PayloadModel> payloads;
    private WorkflowEntityModel workflowEntity;

    public JKManagedBeanWithOrmSupport() {
        this.modelClass = JKFactory.type((Class)JKObjectUtil.getGenericClassFromParent((Object)((Object)this)));
        this.mode = ControllerMode.ADD;
        this.workflowAvialable = JKWorkflowUtil.isWorkflowAvialable();
        if (this.workflowAvialable) {
            this.client.getSystem(JK.getAppName());
            this.workflowEntity = this.client.getWorkflowEntity(JK.getAppName(), this.modelClass.getSimpleName(), this.modelClass.getName());
        }
    }

    public String addToDatabase() {
        if (this.model == null) {
            throw new IllegalStateException("Model is null while calling merge");
        }
        this.beforeInsert();
        T model = this.model;
        this.getDataAccess().insert(model);
        this.afterInsert();
        this.modelList = null;
        this.find(this.getIdValue(model));
        this.success("Added successfully", false);
        return null;
    }

    public String edit() {
        this.mode = ControllerMode.EDIT;
        return null;
    }

    public String saveToDatabase() {
        if (this.model == null) {
            throw new IllegalStateException("Model is null while calling merge");
        }
        this.beforeUpdate();
        T model = this.model;
        this.getDataAccess().update(model);
        this.reset();
        this.afterUpdate();
        this.find(this.getIdValue(model));
        this.success("Updated successfully", true);
        return null;
    }

    protected void beforeInsert() {
    }

    protected void afterInsert() {
    }

    protected void beforeUpdate() {
    }

    protected void afterUpdate() {
    }

    protected void beforeDelete() {
    }

    public String find(int id) {
        Object model = this.getDataAccess().find(this.getModelClass(), (Object)id);
        this.setModel(model);
        this.mode = ControllerMode.READONLY;
        return null;
    }

    protected Class<T> getModelClass() {
        return this.modelClass;
    }

    public List<T> getModelList() {
        if (this.modelList == null) {
            this.modelList = this.getDataAccess().getList(this.getModelClass());
        }
        return this.modelList;
    }

    public String deleteFromDatabase() {
        this.beforeDelete();
        this.getDataAccess().delete(this.getModelClass(), (Object)this.getIdValue());
        this.afterDelete();
        this.reset();
        this.success("Deleted successfully", false);
        return null;
    }

    protected void afterDelete() {
    }

    public Integer getIdValue() {
        return this.getIdValue(this.getModel());
    }

    protected Integer getIdValue(T model) {
        return (Integer)JKObjectUtil.getFieldValue(model, (String)"id");
    }

    public T getModel() {
        if (this.model == null) {
            this.model = this.createEmptyModel();
        }
        return this.model;
    }

    protected T createEmptyModel() {
        return (T)JKObjectUtil.newInstance(this.getModelClass());
    }

    public void setModel(T model) {
        if (model != this.model) {
            this.model = model;
            this.mode = model == null ? ControllerMode.ADD : ControllerMode.READONLY;
        }
    }

    protected JKObjectDataAccess getDataAccess() {
        return (JKObjectDataAccess)JKFactory.instance(JKObjectDataAccessImpl.class);
    }

    public String reset() {
        this.model = null;
        this.modelList = null;
        this.payloads = null;
        this.original = null;
        this.mode = ControllerMode.ADD;
        if (this.isWorkflowAvialable()) {
            this.resetWorkFlow();
        }
        return null;
    }

    protected void resetWorkFlow() {
        String controllerName = "workflow";
        WorkflowController workflow = (WorkflowController)((Object)this.getViewScopedManagedBean(controllerName));
        if (workflow != null) {
            workflow.reset();
            this.updateUi("frmNotifications");
        }
    }

    public boolean isAlwaysRefreshList() {
        return this.alwaysRefreshList;
    }

    public void setAlwaysRefreshList(boolean alwaysRefreshList) {
        this.alwaysRefreshList = alwaysRefreshList;
    }

    public void setIdValue(Object value) {
        JKObjectUtil.setPeopertyValue(this.getModel(), (String)"id", (Object)value);
    }

    public String duplicate() {
        this.model = this.getDataAccess().clone(this.getModel());
        this.setIdValue(0);
        this.mode = ControllerMode.ADD;
        return null;
    }

    public T getEmptyModel() {
        return (T)JKFactory.instance(this.modelClass);
    }

    public String fill() {
        JKMockUtil.fillFields(this.getModel());
        return null;
    }

    public boolean isAllowAdd() {
        return this.mode == ControllerMode.ADD;
    }

    public boolean isAllowEdit() {
        return this.mode == ControllerMode.READONLY;
    }

    public boolean isAllowSave() {
        return this.mode == ControllerMode.EDIT;
    }

    public boolean isAllowDelete() {
        return this.mode == ControllerMode.EDIT;
    }

    public boolean isAllowReset() {
        return this.getMode() != ControllerMode.WORKFLOW;
    }

    public boolean isAllowFill() {
        return this.isAllowAdd() && this.isDevelopmentMode();
    }

    public boolean isEditMode() {
        return this.mode == ControllerMode.EDIT;
    }

    public void cancelEdit() {
        this.mode = ControllerMode.READONLY;
    }

    public boolean isReadOnlyMode() {
        return this.mode == ControllerMode.READONLY;
    }

    public List<T> getFilterList() {
        return this.filterList;
    }

    public void setFilterList2(List filterList2) {
        this.filterList2 = filterList2;
    }

    public void setFilterList(List<T> filterList) {
        this.filterList = filterList;
    }

    public List getFilterList2() {
        return this.filterList2;
    }

    public boolean isConfirmReeset() {
        return this.confirmReeset;
    }

    public void setConfirmReeset(boolean confirmReeset) {
        this.confirmReeset = confirmReeset;
    }

    public ControllerMode getMode() {
        return this.mode;
    }

    public boolean isEditTabular() {
        return this.editTabular;
    }

    public void setEditTabular(boolean editTabular) {
        this.editTabular = editTabular;
    }

    public void saveAllToDatabase() {
        List<T> list = this.getModelList();
        for (T model : list) {
            this.getDataAccess().update(model);
        }
        this.success("Saved succesfully", false);
    }

    public String add() {
        if (!this.isWorkflowAvialable()) {
            return this.addToDatabase();
        }
        this.client.insert(new NewPayloadRequestModel().withEntity(this.getWorkflowEntityName()).withAction(JKWorkflowServiceClient.UserAction.CREATE.toString()).withBody(JKObjectUtil.toJson(this.getModel())).withSystem(JK.getAppName()));
        this.reset();
        this.success("Record sent for the needed approvals");
        return null;
    }

    public String save() {
        if (!this.isWorkflowAvialable()) {
            return this.saveToDatabase();
        }
        this.client.insert(new NewPayloadRequestModel().withEntity(this.getWorkflowEntityName()).withAction(JKWorkflowServiceClient.UserAction.MODIFY.toString()).withBody(JKObjectUtil.toJson(this.getModel())).withSystem(JK.getAppName()));
        this.reset();
        this.success("Record sent for the needed approvals");
        return null;
    }

    public String saveAll() {
        if (this.isWorkflowAvialable()) {
            List<T> list = this.getModelList();
            for (T model : list) {
                this.client.insert(new NewPayloadRequestModel().withEntity(this.getWorkflowEntityName()).withAction(JKWorkflowServiceClient.UserAction.MODIFY.toString()).withBody(JKObjectUtil.toJson(model)).withSystem(JK.getAppName()));
            }
            this.reset();
            this.success("Record sent for the needed approvals");
        } else {
            this.saveAllToDatabase();
            this.setEditTabular(false);
        }
        return null;
    }

    public String delete() {
        if (!this.isWorkflowAvialable()) {
            return this.deleteFromDatabase();
        }
        this.client.insert(new NewPayloadRequestModel().withEntity(this.getWorkflowEntityName()).withAction(JKWorkflowServiceClient.UserAction.DELETE.toString()).withBody(JKObjectUtil.toJson(this.getModel())).withSystem(JK.getAppName()));
        this.reset();
        this.success("Record sent for the needed approvals");
        return null;
    }

    public List<PayloadModel> getPayloads() {
        if (this.payloads == null) {
            this.payloads = this.client.getPayLoads(JK.getAppName(), this.getWorkflowEntityName(), JKCollectionUtil.toString((List)this.getRoles(), (boolean)false));
        }
        return this.payloads;
    }

    public void setPayloads(List<PayloadModel> payloads) {
        this.payloads = payloads;
    }

    protected String getWorkflowEntityName() {
        return this.getModelClass().getSimpleName();
    }

    public boolean isWorkflowAvialable() {
        return this.workflowAvialable && this.workflowEntity != null;
    }

    public PayloadModel getPayload() {
        return this.payload;
    }

    public void setPayload(PayloadModel payload) {
        this.payload = payload;
    }

    public String approvePayload(int id) {
        String approveAction;
        PayloadModel payload = this.findPayload(id);
        if (payload == null) {
            JK.exception((String)("Payload with id ({}) not found." + id));
        }
        if ((approveAction = this.client.approveWorkflowEntity(Integer.valueOf(id))).equals("INSERT")) {
            this.setModel(JKObjectUtil.jsonToObject((String)payload.getPayload(), this.modelClass));
            this.addToDatabase();
        }
        if (approveAction.equals("UPDATE")) {
            this.setModel(JKObjectUtil.jsonToObject((String)payload.getPayload(), this.modelClass));
            this.saveToDatabase();
        }
        if (approveAction.equals("DELETE")) {
            this.setModel(JKObjectUtil.jsonToObject((String)payload.getPayload(), this.modelClass));
            this.deleteFromDatabase();
        }
        this.reset();
        return null;
    }

    public PayloadModel findPayload(int id) {
        for (PayloadModel payload : this.getPayloads()) {
            if (!payload.getId().equals(id)) continue;
            return payload;
        }
        return null;
    }

    public String rejectPayload(int id) {
        String rejectAction = this.client.rejectWorkflowEntity(Integer.valueOf(id));
        this.reset();
        return null;
    }

    public String viewPayload(int id) {
        this.payload = this.findPayload(id);
        this.mode = ControllerMode.WORKFLOW;
        this.model = this.payload.getObject();
        return null;
    }

    public boolean isInputDisabled() {
        return this.mode == ControllerMode.READONLY || this.mode == ControllerMode.WORKFLOW;
    }

    public T getOriginal() {
        int index;
        if (this.getPayload() != null && this.getPayload().getObject() != null && (index = this.getModelList().indexOf(this.getPayload().getObject())) != -1) {
            this.original = this.getModelList().get(index);
        }
        return this.original;
    }

    public void setOriginal(T original) {
        this.original = original;
    }

    public boolean isFieldModified(String name) {
        if (this.getMode() != ControllerMode.ADD && this.getOriginal() != null) {
            Object newValue = JKObjectUtil.getFieldValue(this.getModel(), (String)name);
            Object originalValue = JKObjectUtil.getFieldValue(this.getOriginal(), (String)name);
            if (newValue != null) {
                return !newValue.equals(originalValue);
            }
            if (originalValue != null) {
                return !originalValue.equals(newValue);
            }
        }
        return false;
    }
}

