/*
 * Decompiled with CFR 0.152.
 */
package com.jk.webstack.rest;

import com.jk.core.jpa.BaseEntity;
import com.jk.core.util.JK;
import com.jk.core.util.JKObjectUtil;
import com.jk.data.dataaccess.JKDataAccessFactory;
import com.jk.data.dataaccess.orm.JKObjectDataAccess;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class JKMatureJpaRestService<T extends BaseEntity> {
    JKObjectDataAccess da = JKDataAccessFactory.getObjectDataAccessService();
    private Class<T> clas = JKObjectUtil.getGenericClassFromParent((Object)this);

    public JKMatureJpaRestService() {
        if (this.clas == null) {
            JK.exception((String)"Generic Class must provided in subclass");
        }
    }

    @GET
    public Response get() {
        List stacks = this.da.getList(this.clas);
        return Response.status((int)200).entity((Object)stacks).build();
    }

    @GET
    @Path(value="/{id}")
    public Response get(@PathParam(value="id") String id) {
        BaseEntity stack = (BaseEntity)this.da.find(this.clas, (Object)id);
        if (stack != null) {
            return Response.status((int)200).entity((Object)stack).build();
        }
        return Response.status((int)404).build();
    }

    @POST
    public Response add(T stack) {
        this.da.insert(stack);
        return Response.status((int)201).entity(stack).build();
    }

    @PUT
    @Path(value="/{id}")
    public Response update(@PathParam(value="id") String id, T stack) {
        if (this.da.find(this.clas, (Object)id) != null) {
            this.da.update(stack);
            return Response.status((int)201).entity(stack).build();
        }
        return Response.status((int)404).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") String id) {
        if (this.da.find(this.clas, (Object)id) != null) {
            this.da.delete(this.clas, (Object)id);
            return Response.status((int)201).build();
        }
        return Response.status((int)404).build();
    }
}

