/*
 * Decompiled with CFR 0.152.
 */
package com.jk.webstack.security;

import com.jk.core.config.JKConfig;
import com.jk.core.logging.JKLogger;
import com.jk.core.logging.JKLoggerFactory;
import com.jk.webstack.security.NullAuthenticationProvider;
import com.jk.webstack.security.services.SecurityService;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.firewall.DefaultHttpFirewall;
import org.springframework.security.web.firewall.HttpFirewall;

@EnableWebSecurity
@Configuration
public class JKWebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final String DEFAULT_PUBLIC_URLS = "/services/**,/index.xhtml,/error/**,/login/**,/public/**,/resources/**,*.css,*.js,/javax.faces.resource/**,/util/**";
    JKLogger logger = JKLoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private boolean enabled = JKConfig.getDefaultInstance().getProperty("jk.security.enabled", "false").equals("true");
    @Autowired
    ServletContext context;
    private String[] publicUrls = JKConfig.get().getProperty("jk.web.security.public_url", "/services/**,/index.xhtml,/error/**,/login/**,/public/**,/resources/**,*.css,*.js,/javax.faces.resource/**,/util/**").split(",");

    protected void configure(HttpSecurity http) throws Exception {
        this.logger.info(this.enabled ? "WebSecurity is Enabled" : "WebSecurity is Disabled", new Object[0]);
        if (this.enabled) {
            ((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(this.publicUrls)).permitAll().antMatchers(new String[]{"/admin/**"})).hasAnyAuthority(new String[]{"admin"}).antMatchers(new String[]{"/*/components/**"})).denyAll().anyRequest()).authenticated().and()).formLogin().loginProcessingUrl("/login")).loginPage("/login/index.xhtml").defaultSuccessUrl("/")).failureUrl("/login/")).permitAll()).and()).logout().logoutUrl("/logout").logoutSuccessUrl("/").deleteCookies(new String[]{"JSESSIONID"}).permitAll().and()).exceptionHandling().accessDeniedPage("/error/403.xhtml");
        } else {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{"**"})).permitAll();
        }
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        if (this.enabled) {
            auth.authenticationProvider(this.authenticationProvider());
        }
    }

    @Bean
    public AuthenticationProvider authenticationProvider() {
        if (this.enabled) {
            DaoAuthenticationProvider authProvider = new DaoAuthenticationProvider();
            SecurityService service = new SecurityService();
            authProvider.setUserDetailsService((UserDetailsService)service);
            authProvider.setPasswordEncoder(this.encoder());
            return authProvider;
        }
        return new NullAuthenticationProvider();
    }

    @Bean
    public PasswordEncoder encoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public HttpFirewall defaultHttpFirewall() {
        return new DefaultHttpFirewall();
    }

    @Bean
    public ServletContext getServletContext() {
        return this.context;
    }
}

