/*
 * Decompiled with CFR 0.152.
 */
package com.jk.webstack.security;

import com.jk.webstack.security.UserRole;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
@Table(name="sec_users")
public class User
implements UserDetails,
Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    Integer id;
    String username;
    String firstname;
    String lastname;
    String password;
    @Column(name="verified_email")
    boolean verifiedEmail;
    boolean expired;
    boolean locked;
    @JoinColumn(name="role_id")
    UserRole role;
    @Transient
    private String temp;

    public static User create() {
        return new User();
    }

    public User username(String username) {
        this.setUsername(username);
        return this;
    }

    public User firstname(String firstname) {
        this.setFirstname(firstname);
        return this;
    }

    public User lastname(String lastname) {
        this.setLastname(lastname);
        return this;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        if (this.getRole() == null) {
            return null;
        }
        Vector<UserRole> roles = new Vector<UserRole>();
        roles.add(this.getRole());
        return roles;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return !this.expired;
    }

    public boolean isAccountNonLocked() {
        return !this.locked;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return !this.locked;
    }

    public Integer getId() {
        return this.id;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isVerifiedEmail() {
        return this.verifiedEmail;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public UserRole getRole() {
        return this.role;
    }

    public String getTemp() {
        return this.temp;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setVerifiedEmail(boolean verifiedEmail) {
        this.verifiedEmail = verifiedEmail;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setRole(UserRole role) {
        this.role = role;
    }

    public void setTemp(String temp) {
        this.temp = temp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isVerifiedEmail() != other.isVerifiedEmail()) {
            return false;
        }
        if (this.isExpired() != other.isExpired()) {
            return false;
        }
        if (this.isLocked() != other.isLocked()) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$firstname = this.getFirstname();
        String other$firstname = other.getFirstname();
        if (this$firstname == null ? other$firstname != null : !this$firstname.equals(other$firstname)) {
            return false;
        }
        String this$lastname = this.getLastname();
        String other$lastname = other.getLastname();
        if (this$lastname == null ? other$lastname != null : !this$lastname.equals(other$lastname)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        UserRole this$role = this.getRole();
        UserRole other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)this$role).equals(other$role)) {
            return false;
        }
        String this$temp = this.getTemp();
        String other$temp = other.getTemp();
        return !(this$temp == null ? other$temp != null : !this$temp.equals(other$temp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isVerifiedEmail() ? 79 : 97);
        result = result * 59 + (this.isExpired() ? 79 : 97);
        result = result * 59 + (this.isLocked() ? 79 : 97);
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $firstname = this.getFirstname();
        result = result * 59 + ($firstname == null ? 43 : $firstname.hashCode());
        String $lastname = this.getLastname();
        result = result * 59 + ($lastname == null ? 43 : $lastname.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        UserRole $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)$role).hashCode());
        String $temp = this.getTemp();
        result = result * 59 + ($temp == null ? 43 : $temp.hashCode());
        return result;
    }

    public String toString() {
        return "User(id=" + this.getId() + ", username=" + this.getUsername() + ", firstname=" + this.getFirstname() + ", lastname=" + this.getLastname() + ", password=" + this.getPassword() + ", verifiedEmail=" + this.isVerifiedEmail() + ", expired=" + this.isExpired() + ", locked=" + this.isLocked() + ", role=" + this.getRole() + ", temp=" + this.getTemp() + ")";
    }
}

