/*
 * Decompiled with CFR 0.152.
 */
package com.jk.webstack.security.controllers;

import com.jk.data.exceptions.JKRecordNotFoundException;
import com.jk.web.faces.mb.JKManagedBean;
import com.jk.webstack.services.account.AccountAlreadyExistsException;
import com.jk.webstack.services.account.AccountServices;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;
import javax.servlet.ServletException;

@ManagedBean(name="account")
@RequestScoped
public class MB_Account
extends JKManagedBean {
    String email;
    String firstName;
    String lastName;
    String password;
    boolean created;
    boolean suggestReset;
    AccountServices service = new AccountServices();

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String create() throws ServletException {
        this.logAction("Create Account");
        try {
            this.service.createAccount(this.email, this.firstName, this.lastName, this.password);
            this.request().login(this.email, this.password);
            this.created = true;
            this.redirect("/");
        }
        catch (AccountAlreadyExistsException e) {
            this.suggestReset = true;
            this.error("Account already exists, Please reset password!");
        }
        return null;
    }

    public String resetAccount() {
        this.logAction("Reset Account");
        try {
            this.service.resetAccount(this.email);
            this.success("Thank you. Please check your Email inbox (including the spam folder).", false);
            this.request().setAttribute("resetSucc", (Object)true);
        }
        catch (JKRecordNotFoundException e) {
            this.error("We cant find this Email in our records.", false);
            this.request().setAttribute("createAccount", (Object)true);
        }
        return null;
    }

    public boolean isCreated() {
        return this.created;
    }

    public boolean isSuggestReset() {
        return this.suggestReset;
    }

    public void setSuggestReset(boolean suggestReset) {
        this.suggestReset = suggestReset;
    }
}

