/*
 * Decompiled with CFR 0.152.
 */
package com.jk.webstack.security.controllers;

import com.jk.core.util.JKValidationUtil;
import com.jk.web.util.JKWebUtil;
import com.jk.webstack.controllers.JKManagedBeanWithOrmSupport;
import com.jk.webstack.security.User;
import com.jk.webstack.security.UserRole;
import com.jk.webstack.security.services.SecurityService;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;

@ManagedBean(name="mbUsers")
@ViewScoped
public class MB_Users
extends JKManagedBeanWithOrmSupport<User> {
    private User user;
    String currentPassword;
    String newPassword;

    public String getMessage() {
        Object attribute = this.session().getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        if (attribute == null) {
            return null;
        }
        if (attribute.toString().contains("BadCredentialsException")) {
            return "Invalid username or password";
        }
        return attribute.toString();
    }

    public User getUser() {
        if (this.isUserLoggedIn()) {
            if (this.user == null) {
                this.user = this.getService().loadUserByUsername(this.getUserName());
            }
            return this.user;
        }
        return null;
    }

    protected SecurityService getService() {
        return new SecurityService();
    }

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String changePassword() {
        try {
            this.getService().changePassword(this.getUserName(), this.currentPassword, this.newPassword);
            return "dashboard";
        }
        catch (AssertionError e) {
            this.error("Unable to change password, please check your current password");
            return null;
        }
    }

    public boolean isAdmin() {
        UserRole role = this.getRole();
        if (role != null) {
            return role.getName().equals("admin");
        }
        return false;
    }

    private UserRole getRole() {
        User user = this.getUser();
        if (user != null) {
            return user.getRole();
        }
        return null;
    }

    @Override
    protected void beforeInsert() {
        if (!JKValidationUtil.isEmpty((String)this.newPassword)) {
            ((User)this.getModel()).setPassword(JKWebUtil.encodePassword((String)this.newPassword));
        }
    }

    @Override
    protected void beforeUpdate() {
        if (!JKValidationUtil.isEmpty((String)this.newPassword)) {
            ((User)this.getModel()).setPassword(JKWebUtil.encodePassword((String)this.newPassword));
        }
    }

    @Override
    public String reset() {
        this.newPassword = null;
        return super.reset();
    }
}

