/*
 * Decompiled with CFR 0.152.
 */
package com.jk.webstack.security.services;

import com.jk.core.factory.JKFactory;
import com.jk.core.logging.JKLogger;
import com.jk.core.logging.JKLoggerFactory;
import com.jk.core.security.JKPasswordUtil;
import com.jk.core.util.JKValidationUtil;
import com.jk.data.dataaccess.orm.JKObjectDataAccess;
import com.jk.data.dataaccess.orm.JKObjectDataAccessImpl;
import com.jk.data.exceptions.JKRecordNotFoundException;
import com.jk.web.util.JKWebUtil;
import com.jk.webstack.security.User;
import com.jk.webstack.security.UserRole;
import org.junit.Assert;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class SecurityService
implements UserDetailsService {
    static JKLogger logger = JKLoggerFactory.getLogger(SecurityService.class);
    JKObjectDataAccess dataAccessService = (JKObjectDataAccess)JKFactory.instance(JKObjectDataAccessImpl.class);
    boolean initialized = false;

    protected void init() {
        if (this.dataAccessService.getList(User.class).size() == 0) {
            UserRole role = new UserRole();
            role.setName("admin");
            this.dataAccessService.insert((Object)role);
            this.createAccount("admin", "admin-first-name", "admin-last-name", "admin", role);
        }
    }

    public User loadUserByUsername(String username) throws UsernameNotFoundException {
        User account;
        if (!this.initialized) {
            this.init();
            this.initialized = true;
        }
        if ((account = this.findAccountUsername(username)) == null) {
            throw new UsernameNotFoundException(username);
        }
        return account;
    }

    public User createAccount(String username, String firstname, String lastname, String password, UserRole role) {
        logger.debug((Object)"Create account with ({},{},{})", new Object[]{username, firstname, lastname});
        User account = this.findAccountUsername(username);
        if (account == null) {
            account = User.create().username(username).firstname(firstname).lastname(lastname);
            account.setTemp(password);
            account.setRole(role);
            this.processNewAccount(account);
        } else {
            account.setTemp(password);
            this.processCurrentAccount(account);
        }
        return account;
    }

    protected void processNewAccount(User account) {
        logger.debug((Object)"Process new account ({})", new Object[]{account.getUsername()});
        String password = account.getTemp();
        account.setPassword(JKWebUtil.encodePassword((String)password));
        this.dataAccessService.insert((Object)account);
        logger.debug((Object)"Account created ({}) with password ({})", new Object[]{account.getUsername(), account.getPassword()});
    }

    protected void processCurrentAccount(User account) {
        this.resetAccount(account);
    }

    public User resetAccount(String username) {
        User acconut = this.findAccountUsername(username);
        if (acconut != null) {
            this.resetAccount(acconut);
            return acconut;
        }
        throw new JKRecordNotFoundException();
    }

    protected void resetAccount(User account) {
        logger.debug((Object)"Reset account ({})", new Object[]{account.getUsername()});
        String password = account.getTemp();
        if (JKValidationUtil.isEmpty((String)password)) {
            password = JKPasswordUtil.generateNumricPassword((int)10);
            account.setTemp(password);
        }
        account.setPassword(new BCryptPasswordEncoder().encode((CharSequence)password));
        this.dataAccessService.update((Object)account);
    }

    protected User findAccountUsername(String username) {
        return (User)this.dataAccessService.findOneByFieldName(User.class, "username", (Object)username);
    }

    public void changePassword(String userName, String currentPassword, String newPassword) {
        User account = this.findAccountUsername(userName);
        Assert.assertTrue((account != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)JKWebUtil.matchPasswords((String)currentPassword, (String)account.getPassword()));
        account.setPassword(JKWebUtil.encodePassword((String)newPassword));
        this.dataAccessService.update((Object)account);
    }
}

