/*
 * Decompiled with CFR 0.152.
 */
package com.jk.webstack.services.account;

import com.jk.core.jpa.BaseEntity;
import com.jk.core.util.JKDateTimeUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
@Table(name="app_accounts")
public class Account
extends BaseEntity
implements UserDetails,
Serializable {
    private static final int TOKEN_TIME_OUT = 30;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    Integer id;
    String email;
    String firstname;
    String lastname;
    String password;
    @Column(name="verified_email")
    boolean verifiedEmail;
    boolean expired;
    boolean locked;
    @Column(name="token")
    String oneTimeToken;
    @Column(name="token_time")
    Date oneTokenTime;
    @Transient
    private String temp;

    public static Account create() {
        return new Account();
    }

    public Account email(String email) {
        this.setEmail(email);
        return this;
    }

    public Account firstname(String firstname) {
        this.setFirstname(firstname);
        return this;
    }

    public Account lastname(String lastname) {
        this.setLastname(lastname);
        return this;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return null;
    }

    public String getUsername() {
        return this.getEmail();
    }

    public boolean isAccountNonExpired() {
        return !this.expired;
    }

    public boolean isAccountNonLocked() {
        return !this.locked;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return !this.locked;
    }

    public boolean isTokenExpired() {
        Date time = this.getOneTokenTime();
        if (time == null) {
            return true;
        }
        if (JKDateTimeUtil.getMinutesDifference((Date)new Date(), (Date)time) > 30L) {
            return false;
        }
        return false;
    }

    @PrePersist
    public void prePersist() {
        super.prePersist();
    }

    @PreUpdate
    public void preUpdate() {
        super.preUpdate();
    }

    public Integer getId() {
        return this.id;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isVerifiedEmail() {
        return this.verifiedEmail;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public String getOneTimeToken() {
        return this.oneTimeToken;
    }

    public Date getOneTokenTime() {
        return this.oneTokenTime;
    }

    public String getTemp() {
        return this.temp;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setVerifiedEmail(boolean verifiedEmail) {
        this.verifiedEmail = verifiedEmail;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setOneTimeToken(String oneTimeToken) {
        this.oneTimeToken = oneTimeToken;
    }

    public void setOneTokenTime(Date oneTokenTime) {
        this.oneTokenTime = oneTokenTime;
    }

    public void setTemp(String temp) {
        this.temp = temp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isVerifiedEmail() != other.isVerifiedEmail()) {
            return false;
        }
        if (this.isExpired() != other.isExpired()) {
            return false;
        }
        if (this.isLocked() != other.isLocked()) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$firstname = this.getFirstname();
        String other$firstname = other.getFirstname();
        if (this$firstname == null ? other$firstname != null : !this$firstname.equals(other$firstname)) {
            return false;
        }
        String this$lastname = this.getLastname();
        String other$lastname = other.getLastname();
        if (this$lastname == null ? other$lastname != null : !this$lastname.equals(other$lastname)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$oneTimeToken = this.getOneTimeToken();
        String other$oneTimeToken = other.getOneTimeToken();
        if (this$oneTimeToken == null ? other$oneTimeToken != null : !this$oneTimeToken.equals(other$oneTimeToken)) {
            return false;
        }
        Date this$oneTokenTime = this.getOneTokenTime();
        Date other$oneTokenTime = other.getOneTokenTime();
        if (this$oneTokenTime == null ? other$oneTokenTime != null : !((Object)this$oneTokenTime).equals(other$oneTokenTime)) {
            return false;
        }
        String this$temp = this.getTemp();
        String other$temp = other.getTemp();
        return !(this$temp == null ? other$temp != null : !this$temp.equals(other$temp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Account;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isVerifiedEmail() ? 79 : 97);
        result = result * 59 + (this.isExpired() ? 79 : 97);
        result = result * 59 + (this.isLocked() ? 79 : 97);
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $firstname = this.getFirstname();
        result = result * 59 + ($firstname == null ? 43 : $firstname.hashCode());
        String $lastname = this.getLastname();
        result = result * 59 + ($lastname == null ? 43 : $lastname.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $oneTimeToken = this.getOneTimeToken();
        result = result * 59 + ($oneTimeToken == null ? 43 : $oneTimeToken.hashCode());
        Date $oneTokenTime = this.getOneTokenTime();
        result = result * 59 + ($oneTokenTime == null ? 43 : ((Object)$oneTokenTime).hashCode());
        String $temp = this.getTemp();
        result = result * 59 + ($temp == null ? 43 : $temp.hashCode());
        return result;
    }

    public String toString() {
        return "Account(id=" + this.getId() + ", email=" + this.getEmail() + ", firstname=" + this.getFirstname() + ", lastname=" + this.getLastname() + ", password=" + this.getPassword() + ", verifiedEmail=" + this.isVerifiedEmail() + ", expired=" + this.isExpired() + ", locked=" + this.isLocked() + ", oneTimeToken=" + this.getOneTimeToken() + ", oneTokenTime=" + this.getOneTokenTime() + ", temp=" + this.getTemp() + ")";
    }
}

