/*
 * Decompiled with CFR 0.152.
 */
package com.jk.webstack.services.account;

import com.jk.core.exceptions.JKInvalidTokenException;
import com.jk.core.factory.JKFactory;
import com.jk.core.logging.JKLogger;
import com.jk.core.logging.JKLoggerFactory;
import com.jk.core.security.JKPasswordUtil;
import com.jk.core.security.JKSecurityUtil;
import com.jk.core.templates.JKTemplateUtil;
import com.jk.core.util.JK;
import com.jk.core.util.JKValidationUtil;
import com.jk.data.dataaccess.orm.JKObjectDataAccess;
import com.jk.data.dataaccess.orm.JKObjectDataAccessImpl;
import com.jk.data.exceptions.JKRecordNotFoundException;
import com.jk.web.util.JKWebUtil;
import com.jk.webstack.services.account.Account;
import com.jk.webstack.services.account.AccountAlreadyExistsException;
import com.jk.webstack.services.email.EmailService;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.junit.Assert;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class AccountServices
implements UserDetailsService {
    static JKLogger logger = JKLoggerFactory.getLogger(AccountServices.class);
    JKObjectDataAccess dataAccessService = (JKObjectDataAccess)JKFactory.instance(JKObjectDataAccessImpl.class);
    EmailService emailService = new EmailService();

    public Account loadUserByUsername(String username) throws UsernameNotFoundException {
        Account account = this.findAccountByEmail(username);
        if (account == null) {
            throw new UsernameNotFoundException(username);
        }
        return account;
    }

    public Account createAccount(String email, String firstname, String lastname, String password) throws AccountAlreadyExistsException {
        logger.debug((Object)"Create account with ({},{},{})", new Object[]{email, firstname, lastname});
        Account account = this.findAccountByEmail(email);
        if (account != null) {
            throw new AccountAlreadyExistsException();
        }
        account = Account.create().email(email).firstname(firstname).lastname(lastname);
        account.setTemp(password);
        this.processNewAccount(account);
        return account;
    }

    protected void processNewAccount(Account account) {
        logger.debug((Object)"Process new account ({})", new Object[]{account.getEmail()});
        String password = account.getTemp();
        boolean sendWelcomeEmail = false;
        if (JKValidationUtil.isEmpty((String)password)) {
            password = JKPasswordUtil.generateNumricPassword((int)10);
            account.setTemp(password);
            sendWelcomeEmail = true;
        }
        account.setPassword(JKWebUtil.encodePassword((String)password));
        this.createToken(account);
        this.dataAccessService.insert((Object)account);
        logger.debug((Object)"Account created ({}) with password ({})", new Object[]{account.getEmail(), account.getPassword()});
        if (sendWelcomeEmail) {
            this.sendWelcomeEmail(account, password);
        }
    }

    protected void processCurrentAccount(Account account) {
        this.resetAccount(account);
    }

    public Account resetAccount(String email) {
        Account acconut = this.findAccountByEmail(email);
        if (acconut != null) {
            this.resetAccount(acconut);
            return acconut;
        }
        throw new JKRecordNotFoundException();
    }

    protected void resetAccount(Account account) {
        logger.debug((Object)"Reset account ({})", new Object[]{account.getEmail()});
        String password = account.getTemp();
        boolean sendResetEmail = false;
        password = JKPasswordUtil.generateNumricPassword((int)10);
        account.setTemp(password);
        sendResetEmail = true;
        account.setPassword(new BCryptPasswordEncoder().encode((CharSequence)password));
        this.createToken(account);
        this.dataAccessService.update((Object)account);
        if (sendResetEmail) {
            this.sendResetEmail(account, password);
        }
    }

    private void sendResetEmail(Account account, String password) {
        Map map = JK.toMap((Object[])new Object[]{"firstname", account.getFirstname(), "password", password, "link", this.createLoginLink(account)});
        String emailContents = JKTemplateUtil.compile((String)"/templates/email", (String)"reset_account.ftl", (Map)map);
        this.emailService.addEmailToQueue(account.getEmail(), "Reset Password from Clowiz (the Cloud-Wizard)", emailContents, true);
    }

    private void sendWelcomeEmail(Account account, String password) {
        Map map = JK.toMap((Object[])new Object[]{"firstname", account.getFirstname(), "password", password, "link", this.createLoginLink(account)});
        logger.debug((Object)"Send welcome email with params({})", new Object[]{map});
        String emailContents = JKTemplateUtil.compile((String)"/templates/email", (String)"welcome-account.ftl", (Map)map);
        this.emailService.addEmailToQueue(account.getEmail(), "Welcome to Clowiz (the Cloud-Wizard)", emailContents, true);
    }

    protected String createLoginLink(Account account) {
        String email = account.getEmail();
        String token = account.getOneTimeToken();
        String param = JKSecurityUtil.encode((String)(email + "," + token));
        String url = String.format("https://www.clowiz.com/login2?ac=%s", param);
        return url;
    }

    public Account loadDetailsByToken(String tokenString) {
        String decode = null;
        try {
            decode = JKSecurityUtil.decode((String)tokenString);
        }
        catch (IllegalArgumentException e) {
            throw new JKInvalidTokenException("Invalid token structure");
        }
        String[] data = decode.split(",");
        if (data.length != 2) {
            throw new JKInvalidTokenException("Invalid token structure");
        }
        String email = data[0];
        String tokenValue = data[1];
        Account account = this.findAccountByEmail(email);
        try {
            if (account == null) {
                throw new JKInvalidTokenException("Email is not valid:" + email);
            }
            if (account.getOneTimeToken() != null && account.getOneTimeToken().equals(tokenValue) && !account.isTokenExpired()) {
                Account account2 = account;
                return account2;
            }
            throw new JKInvalidTokenException("Token is not valid :" + tokenValue);
        }
        finally {
            this.resetToken(account);
        }
    }

    protected void resetToken(Account account) {
        account.setOneTimeToken(null);
        this.dataAccessService.update((Object)account);
    }

    protected void createToken(Account account) {
        UUID uuid = UUID.nameUUIDFromBytes(account.getPassword().getBytes());
        account.setOneTimeToken(uuid.toString());
        account.setOneTokenTime(new Date());
    }

    public static void main(String[] args) {
        AccountServices service = new AccountServices();
    }

    public void setEmailVerified(Account account) {
        Map map = JK.toMap((Object[])new Object[]{"verified_email", true});
    }

    protected Account findAccountByEmail(String email) {
        return (Account)this.dataAccessService.findOneByFieldName(Account.class, "email", (Object)email);
    }

    public void changePassword(String userName, String currentPassword, String newPassword) {
        Account account = this.findAccountByEmail(userName);
        Assert.assertTrue((account != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)JKWebUtil.matchPasswords((String)currentPassword, (String)account.getPassword()));
        account.setPassword(JKWebUtil.encodePassword((String)newPassword));
        this.dataAccessService.update((Object)account);
    }
}

