/*
 * Decompiled with CFR 0.152.
 */
package com.jk.webstack.services.email;

import com.jk.core.factory.JKFactory;
import com.jk.core.logging.JKLogger;
import com.jk.core.logging.JKLoggerFactory;
import com.jk.core.mail.JKMailInfo;
import com.jk.core.mail.JKMailSender;
import com.jk.core.util.JKConversionUtil;
import com.jk.data.dataaccess.orm.JKObjectDataAccess;
import com.jk.data.dataaccess.orm.JKObjectDataAccessImpl;
import com.jk.webstack.services.email.Email;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class EmailService {
    static ExecutorService pool = Executors.newCachedThreadPool();
    static JKLogger logger = JKLoggerFactory.getLogger(EmailService.class);
    JKObjectDataAccess dataAccessService = (JKObjectDataAccess)JKFactory.instance(JKObjectDataAccessImpl.class);
    private JKMailSender sender;

    public void addEmailToQueue(String to, String subject, String emailContents, boolean callSend) {
        logger.debug((Object)"Adding new email to the queue To({}) with subject ({})", new Object[]{to, subject});
        Email email = new Email();
        email.setTo(to);
        email.setSubject(subject);
        email.setBody(emailContents);
        this.dataAccessService.insert((Object)email);
        if (callSend) {
            pool.execute(() -> this.sendEmailsInQueue());
        }
    }

    public void sendEmailsInQueue() {
        logger.debug((Object)"Sending emails in Queue", new Object[0]);
        JKMailInfo info = new JKMailInfo();
        info.setUsername(System.getProperty("jk-email-user", ""));
        info.setPassword(System.getProperty("jk-email-password", ""));
        info.setRequiresAuthentication(true);
        info.setSecured(true);
        List<Email> emails = this.getEmailsInQueue();
        JKMailSender emailSender = this.getEmailSender();
        info.setHost(System.getProperty("jk-email-server", ""));
        info.setSmtpPort(JKConversionUtil.toInteger((Object)System.getProperty("jk-email-port", "")).intValue());
        info.setFrom("");
        info.setBcc("");
        logger.debug((Object)"Total emails ({})", new Object[]{emails.size()});
        for (Email email : emails) {
            info.setTo(email.getTo());
            info.setSubject(email.getSubject());
            info.setMsg(email.getBody());
            emailSender.send(info);
            this.dataAccessService.delete((Object)email);
        }
    }

    public List<Email> getEmailsInQueue() {
        List emails = this.dataAccessService.getList(Email.class);
        return emails;
    }

    protected JKMailSender getEmailSender() {
        if (this.sender == null) {
            logger.debug((Object)"No Email Sender is provided, default will be used", new Object[0]);
            this.sender = new JKMailSender();
        }
        return this.sender;
    }

    public void setSender(JKMailSender sender) {
        this.sender = sender;
    }

    public static void main(String[] args) {
        EmailService s = new EmailService();
        s.addEmailToQueue("jalal@nevada.unr.edu", "Hi", "Hi Jalal, This is Naser, I just want to say hi", true);
    }
}

