/*
 * Decompiled with CFR 0.152.
 */
package com.jk.webstack.services.logging;

import com.jk.data.dataaccess.JKDataAccessFactory;
import com.jk.data.dataaccess.core.JKDataAccessService;
import com.jk.data.dataaccess.orm.JKObjectDataAccess;
import com.jk.data.exceptions.JKRecordNotFoundException;
import com.jk.webstack.services.logging.UserActionLog;
import java.util.Date;

public class ActionLogsService {
    JKDataAccessService dataAccessImpl = JKDataAccessFactory.getDataAccessService();
    JKObjectDataAccess objectDataAccess = JKDataAccessFactory.getObjectDataAccessService();

    public void logAction(String statType) {
        try {
            this.dataAccessImpl.executeUpdate("UPDATE app_action_logs SET log_count=log_count+1 WHERE log_type=?", new Object[]{statType});
        }
        catch (JKRecordNotFoundException e) {
            this.dataAccessImpl.executeUpdate("INSERT INTO app_action_logs(log_type,log_count) VALUES(?,1)", new Object[]{statType});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getActionLogCount(String logType) {
        return this.dataAccessImpl.executeQueryAsInteger("SELECT log_count FROM app_action_logs WHERE log_type=?", new Object[]{logType});
    }

    public void logUserAction(String className, String actionName, String userName) {
        UserActionLog log = new UserActionLog();
        log.setLogClass(className);
        log.setLogType(actionName);
        log.setUserName(userName);
        log.setTime(new Date());
        this.objectDataAccess.insert((Object)log);
    }
}

