/*
 * Decompiled with CFR 0.152.
 */
package com.jk.webstack.services.mointor;

import com.jk.core.logging.JKLogger;
import com.jk.core.logging.JKLoggerFactory;
import com.jk.core.util.JK;
import com.jk.data.dataaccess.JKDataAccessFactory;
import com.jk.web.monitoring.JKMonitorService;
import com.jk.webstack.services.mointor.Event;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class JKWebStackMonitor
extends JKMonitorService {
    JKLogger logger = JKLoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private boolean serviceAvailable;

    public JKWebStackMonitor() {
        this.logger.info("Initialized", new Object[0]);
        this.serviceAvailable = JKDataAccessFactory.isEntityAvailable(Event.class);
        if (!this.serviceAvailable) {
            this.logger.info("Exceptions will not be logged into DB, add (com.jk.webstack.services.mointor) to your config.properties under (db-entities-packages) section", new Object[0]);
        }
    }

    public void publish(HttpServletRequest request, Throwable exception) {
        JK.fixMe((String)"Make it async");
        if (this.serviceAvailable) {
            try {
                String name = exception.getMessage();
                if (name.length() > 255) {
                    name = name.substring(0, 255);
                }
                String userName = this.getUserName(request);
                this.logger.debug((Object)"Publishing Exception ({}) for user ({})", new Object[]{exception.getMessage(), userName});
                Event e = new Event();
                e.setEventType("Exception");
                e.setCrtUser(userName);
                e.setName(name);
                e.setEventText(ExceptionUtils.getStackTrace((Throwable)exception));
                JKDataAccessFactory.getObjectDataAccessService().insert((Object)e);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to publish error: " + exception.getMessage() + " , for the following reason: " + e.getMessage()), new Object[0]);
            }
        }
    }
}

