/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.csv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scriptella.driver.csv.CsvProviderException;
import scriptella.driver.csv.opencsv.CSVReader;
import scriptella.expression.PropertiesSubstitutor;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ParametersCallback;
import scriptella.spi.QueryCallback;
import scriptella.util.ColumnsMap;
import scriptella.util.ExceptionUtils;

public class CsvQuery
implements ParametersCallback {
    protected static final Logger LOG = Logger.getLogger(CsvQuery.class.getName());
    protected final boolean headers;
    protected final boolean trim;
    protected final String nullString;
    private ColumnsMap columnsMap;
    private String[] row;
    private Pattern[][] patterns;
    private Matcher[][] matchers;
    private PropertiesSubstitutor substitutor;

    public CsvQuery(CSVReader queryReader, PropertiesSubstitutor substitutor, String nullString, boolean headers, boolean trim) {
        this.headers = headers;
        this.trim = trim;
        this.nullString = nullString;
        this.substitutor = substitutor;
        this.compileQueries(queryReader);
        CsvQuery.closeSilently(queryReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CSVReader reader, QueryCallback queryCallback, AbstractConnection.StatementCounter counter) throws IOException {
        try {
            String[] r;
            this.columnsMap = this.parseHeader(reader);
            while ((r = this.trim(reader.readNext())) != null) {
                if (!this.rowMatches(r)) continue;
                this.processRow(queryCallback, r);
            }
        }
        finally {
            CsvQuery.closeSilently(reader);
        }
        if (this.patterns != null) {
            counter.statements += (long)this.patterns.length;
        }
        this.columnsMap = null;
        this.row = null;
    }

    protected ColumnsMap parseHeader(CSVReader reader) throws IOException {
        String[] row;
        ColumnsMap columnsMap = new ColumnsMap();
        if (this.headers && (row = reader.readNext()) != null) {
            for (int i = 0; i < row.length; ++i) {
                columnsMap.registerColumn(row[i].trim(), i + 1);
            }
        }
        return columnsMap;
    }

    protected boolean rowMatches(String[] r) {
        Pattern[][] ptrs = this.patterns;
        int columnsCount = r.length;
        if (ptrs == null) {
            return true;
        }
        if (columnsCount == 0) {
            return false;
        }
        for (int i = 0; i < ptrs.length; ++i) {
            Pattern[] rowPatterns = ptrs[i];
            Matcher[] rowMatchers = this.matchers[i];
            boolean rowMatches = true;
            int patternsCount = rowPatterns.length;
            if (patternsCount > columnsCount) continue;
            for (int j = 0; j < patternsCount; ++j) {
                Pattern columnPtr = rowPatterns[j];
                if (columnPtr == null) continue;
                Matcher m = rowMatchers[j];
                String col = r[j];
                if (m == null) {
                    rowMatchers[j] = m = columnPtr.matcher(col);
                } else {
                    m.reset(col);
                }
                if (m.find()) continue;
                rowMatches = false;
                break;
            }
            if (!rowMatches) continue;
            return true;
        }
        return false;
    }

    protected void processRow(QueryCallback queryCallback, String[] r) {
        this.row = r;
        queryCallback.processRow((ParametersCallback)this);
    }

    void compileQueries(CSVReader r) {
        int i;
        List<String[]> list;
        try {
            list = r.readAll();
        }
        catch (IOException e) {
            throw new CsvProviderException("Unable to read CSV query", e);
        }
        ArrayList<Pattern[]> res = null;
        for (String[] columns : list) {
            Pattern[] patterns = null;
            this.trim(columns);
            for (i = 0; i < columns.length; ++i) {
                String s = columns[i];
                if (s == null || s.length() <= 0) continue;
                if (patterns == null) {
                    patterns = new Pattern[columns.length];
                }
                try {
                    patterns[i] = Pattern.compile(this.substitutor.substitute(s), 34);
                    continue;
                }
                catch (Exception e) {
                    throw new CsvProviderException("Illegal regular expression syntax for query", e, s);
                }
            }
            if (patterns == null) continue;
            if (res == null) {
                res = new ArrayList<Pattern[]>();
            }
            res.add(patterns);
        }
        if (res != null) {
            int len = res.size();
            Pattern[][] ptrs = (Pattern[][])res.toArray((T[])new Pattern[len][]);
            Matcher[][] matchers = new Matcher[len][];
            for (i = 0; i < len; ++i) {
                matchers[i] = new Matcher[ptrs[i].length];
            }
            this.patterns = ptrs;
            this.matchers = matchers;
        }
    }

    private String[] trim(String[] s) {
        if (s != null && this.trim) {
            for (int i = 0; i < s.length; ++i) {
                if (s[i] == null) continue;
                s[i] = s[i].trim();
            }
        }
        return s;
    }

    public Object getParameter(String name) {
        if (this.columnsMap == null) {
            throw new IllegalStateException("CSV Resultset is closed");
        }
        Integer col = this.columnsMap.find(name);
        if (col != null && col > 0 && col <= this.row.length) {
            return this.getCurrentRowValueAt(col, name);
        }
        return this.substitutor.getParameters().getParameter(name);
    }

    protected Object getCurrentRowValueAt(int columnIndex, String columnName) {
        String s = this.row[columnIndex - 1];
        return this.nullString != null && this.nullString.equals(s) ? null : s;
    }

    protected ColumnsMap getColumnsMap() {
        return this.columnsMap;
    }

    static void closeSilently(CSVReader reader) {
        try {
            reader.close();
        }
        catch (Exception e) {
            ExceptionUtils.ignoreThrowable((Throwable)e);
        }
    }
}

