/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.csv.opencsv;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;

public class CSVWriter
implements Closeable {
    private Writer writer;
    private char separator;
    private char quotechar;
    private String lineEnd;
    public static final char ESCAPE_CHARACTER = '\"';
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    public static final String DEFAULT_LINE_END = "\n";

    public CSVWriter(Writer writer) {
        this(writer, ',');
    }

    public CSVWriter(Writer writer, char separator) {
        this(writer, separator, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar) {
        this(writer, separator, quotechar, DEFAULT_LINE_END);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, String lineEnd) {
        this.writer = writer;
        this.separator = separator;
        this.quotechar = quotechar;
        this.lineEnd = lineEnd;
    }

    public void writeNext(String[] nextLine) throws IOException {
        int colCount = nextLine.length;
        for (int i = 0; i < colCount; ++i) {
            String nextElement;
            if (i != 0) {
                this.writer.append(this.separator);
            }
            if ((nextElement = nextLine[i]) == null) continue;
            if (this.quotechar != '\u0000') {
                this.writer.append(this.quotechar);
            }
            int length = nextElement.length();
            for (int j = 0; j < length; ++j) {
                char nextChar = nextElement.charAt(j);
                if (nextChar == this.quotechar) {
                    this.writer.append('\"').append(nextChar);
                    continue;
                }
                if (nextChar == '\"') {
                    this.writer.append('\"').append(nextChar);
                    continue;
                }
                this.writer.append(nextChar);
            }
            if (this.quotechar == '\u0000') continue;
            this.writer.append(this.quotechar);
        }
        this.writer.append(this.lineEnd);
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }
}

