/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.hsqldb;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import scriptella.driver.hsqldb.HsqlConnection;
import scriptella.jdbc.GenericDriver;
import scriptella.jdbc.JdbcConnection;
import scriptella.spi.ConnectionParameters;

public class Driver
extends GenericDriver {
    private static final Logger LOG = Logger.getLogger(Driver.class.getName());
    public static final String HSQLDB_DRIVER_NAME = "org.hsqldb.jdbcDriver";
    private static Map<String, HsqlConnection> lastConnections = null;
    private static boolean hookAdded = false;
    static final Thread HOOK = new Thread("Scriptella HSLQDB Shutdown Fix"){

        public void run() {
            if (lastConnections != null) {
                for (Map.Entry entry : lastConnections.entrySet()) {
                    try {
                        ((HsqlConnection)((Object)entry.getValue())).shutdown();
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "Problem occured while trying to shutdown an in-process HSQLDB database " + (String)entry.getKey(), e);
                    }
                }
                lastConnections = null;
            }
        }
    };

    public Driver() {
        this.loadDrivers(new String[]{HSQLDB_DRIVER_NAME});
    }

    protected JdbcConnection connect(ConnectionParameters parameters, Properties props) throws SQLException {
        return new HsqlConnection(this.getConnection(parameters.getUrl(), props), parameters);
    }

    static synchronized HsqlConnection setLastConnection(HsqlConnection connection) {
        if (lastConnections == null) {
            lastConnections = new HashMap<String, HsqlConnection>();
        }
        HsqlConnection old = lastConnections.put(Driver.getConnectionURL(connection), connection);
        if (!hookAdded) {
            Runtime.getRuntime().addShutdownHook(HOOK);
            hookAdded = true;
        }
        return old;
    }

    private static String getConnectionURL(HsqlConnection connection) {
        try {
            return connection.getNativeConnection().getMetaData().getURL();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to read connection meta data", e);
            return "";
        }
    }
}

