/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.hsqldb;

import java.sql.Connection;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import scriptella.driver.hsqldb.Driver;
import scriptella.jdbc.JdbcConnection;
import scriptella.jdbc.JdbcUtils;
import scriptella.spi.ConnectionParameters;

public class HsqlConnection
extends JdbcConnection {
    public static final String SHUTDOWN_ON_EXIT = "shutdown_on_exit";
    private static final Logger LOG = Logger.getLogger(HsqlConnection.class.getName());
    private boolean shutdownOnExit;

    HsqlConnection(Connection con, ConnectionParameters parameters) {
        super(con, parameters);
    }

    protected void init(ConnectionParameters parameters) {
        super.init(parameters);
        this.shutdownOnExit = parameters.getBooleanProperty(SHUTDOWN_ON_EXIT, true) && HsqlConnection.isInprocess(parameters.getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Statement st;
        Connection con;
        block6: {
            assert (this.shutdownOnExit);
            con = this.getNativeConnection();
            st = null;
            if (con != null && !con.isClosed()) break block6;
            LOG.info("Unable to correctly shutdown in-process HSQLDB. Connection has already already been closed");
            JdbcUtils.closeSilent(st);
            JdbcUtils.closeSilent((Connection)con);
            return;
        }
        try {
            st = con.createStatement();
            st.execute("SHUTDOWN");
        }
        catch (Exception e) {
            try {
                LOG.log(Level.WARNING, "Problem occured while trying to shutdown in-process HSQLDB", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeSilent(st);
                JdbcUtils.closeSilent((Connection)con);
                throw throwable;
            }
            JdbcUtils.closeSilent((Statement)st);
            JdbcUtils.closeSilent((Connection)con);
        }
        JdbcUtils.closeSilent((Statement)st);
        JdbcUtils.closeSilent((Connection)con);
    }

    public void close() {
        if (this.shutdownOnExit) {
            HsqlConnection previous = Driver.setLastConnection(this);
            if (previous != null) {
                previous.shutdownOnExit = false;
                previous.close();
            }
        } else {
            super.close();
        }
    }

    private static boolean isInprocess(String url) {
        if (url.startsWith("jdbc:hsqldb:http:")) {
            return false;
        }
        if (url.startsWith("jdbc:hsqldb:https:")) {
            return false;
        }
        if (url.startsWith("jdbc:hsqldb:hsql")) {
            return false;
        }
        return !url.startsWith("jdbc:hsqldb:hsqls");
    }
}

