/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.janino;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.IdentityHashMap;
import java.util.Map;
import org.codehaus.janino.ScriptEvaluator;
import org.codehaus.janino.util.LocatedException;
import scriptella.driver.janino.JaninoProviderException;
import scriptella.driver.janino.JaninoQuery;
import scriptella.driver.janino.JaninoScript;
import scriptella.expression.LineIterator;
import scriptella.spi.Resource;
import scriptella.util.ExceptionUtils;
import scriptella.util.IOUtils;

final class CodeCompiler {
    private static final Class[] THROWN_EXCEPTIONS = new Class[]{Exception.class};
    private Map<Resource, Object> objectCache = new IdentityHashMap<Resource, Object>();

    CodeCompiler() {
    }

    public JaninoScript compileScript(Resource resource) {
        return (JaninoScript)this.compile(resource, false);
    }

    public JaninoQuery compileQuery(Resource resource) {
        return (JaninoQuery)this.compile(resource, true);
    }

    private Object compile(Resource content, boolean query) {
        Object ctx = this.objectCache.get(content);
        if (ctx == null) {
            ScriptEvaluator evaluator = new ScriptEvaluator();
            evaluator.setThrownExceptions(THROWN_EXCEPTIONS);
            evaluator.setParentClassLoader(this.getClass().getClassLoader());
            Class type = query ? JaninoQuery.class : JaninoScript.class;
            evaluator.setExtendedType(type);
            evaluator.setStaticMethod(false);
            evaluator.setMethodName("execute");
            evaluator.setClassName(type.getName() + "_Generated");
            Reader r = null;
            try {
                r = content.open();
                evaluator.cook(content.toString(), r);
            }
            catch (Exception e) {
                throw CodeCompiler.guestErrorStatement(new JaninoProviderException("Compilation failed", e), content);
            }
            finally {
                IOUtils.closeSilently((Closeable)r);
            }
            Class<?> cl = evaluator.getMethod().getDeclaringClass();
            try {
                ctx = cl.newInstance();
            }
            catch (Exception e) {
                throw new JaninoProviderException("Unable to instantiate compiled class", e);
            }
            this.objectCache.put(content, ctx);
        }
        return ctx;
    }

    private static JaninoProviderException guestErrorStatement(JaninoProviderException pe, Resource r) {
        LocatedException le;
        Throwable cause = pe.getCause();
        if (cause instanceof LocatedException && (le = (LocatedException)cause).getLocation() != null) {
            String line = CodeCompiler.getLine(r, le.getLocation().getLineNumber());
            pe.setErrorStatement(line);
        }
        return pe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getLine(Resource resource, int line) {
        String string;
        LineIterator it = null;
        try {
            it = new LineIterator(resource.open());
            string = it.getLineAt(line - 1);
        }
        catch (IOException e) {
            try {
                ExceptionUtils.ignoreThrowable((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(it);
                throw throwable;
            }
            IOUtils.closeSilently((Closeable)it);
            return null;
        }
        IOUtils.closeSilently((Closeable)it);
        return string;
    }
}

