/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.janino;

import scriptella.driver.janino.CodeCompiler;
import scriptella.driver.janino.Driver;
import scriptella.driver.janino.JaninoProviderException;
import scriptella.driver.janino.JaninoQuery;
import scriptella.driver.janino.JaninoScript;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ConnectionParameters;
import scriptella.spi.ParametersCallback;
import scriptella.spi.ProviderException;
import scriptella.spi.QueryCallback;
import scriptella.spi.Resource;

public class JaninoConnection
extends AbstractConnection {
    private CodeCompiler compiler = new CodeCompiler();

    public JaninoConnection(ConnectionParameters parameters) {
        super(Driver.DIALECT_IDENTIFIER, parameters);
    }

    public void executeScript(Resource scriptContent, ParametersCallback parametersCallback) throws ProviderException {
        JaninoScript s = this.compiler.compileScript(scriptContent);
        s.setParametersCallback(parametersCallback);
        try {
            s.execute();
        }
        catch (Exception e) {
            throw JaninoConnection.guessErrorStatement(new JaninoProviderException("Script execution failed due to exception", e), scriptContent, s.getClass());
        }
        finally {
            s.setParametersCallback(null);
        }
    }

    public void executeQuery(Resource queryContent, ParametersCallback parametersCallback, QueryCallback queryCallback) throws ProviderException {
        JaninoQuery q = this.compiler.compileQuery(queryContent);
        q.setParametersCallback(parametersCallback);
        q.setQueryCallback(queryCallback);
        try {
            q.execute();
        }
        catch (Exception e) {
            throw JaninoConnection.guessErrorStatement(new JaninoProviderException("Query execution failed due to exception", e), queryContent, q.getClass());
        }
        finally {
            q.setParametersCallback(null);
            q.setQueryCallback(null);
        }
    }

    private static JaninoProviderException guessErrorStatement(JaninoProviderException e, Resource content, Class scriptClass) {
        Throwable ex = e.getCause();
        StackTraceElement[] trace = ex.getStackTrace();
        String scriptClassName = scriptClass.getName();
        for (StackTraceElement el : trace) {
            String className = el.getClassName();
            if (!scriptClassName.equals(className)) continue;
            String st = CodeCompiler.getLine(content, el.getLineNumber());
            e.setErrorStatement(st);
            break;
        }
        return e;
    }

    public void close() throws ProviderException {
        this.compiler = null;
    }
}

