/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.jexl;

import java.io.IOException;
import java.io.Reader;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.Script;
import org.apache.commons.jexl.ScriptFactory;
import scriptella.driver.jexl.Driver;
import scriptella.driver.jexl.JexlContextMap;
import scriptella.driver.jexl.JexlProviderException;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ConnectionParameters;
import scriptella.spi.ParametersCallback;
import scriptella.spi.ProviderException;
import scriptella.spi.QueryCallback;
import scriptella.spi.Resource;
import scriptella.util.IOUtils;

public class JexlConnection
extends AbstractConnection {
    private Map<Resource, Script> cache = new IdentityHashMap<Resource, Script>();

    public JexlConnection(ConnectionParameters parameters) {
        super(Driver.DIALECT, parameters);
    }

    public void executeScript(Resource scriptContent, ParametersCallback parametersCallback) throws ProviderException {
        this.run(scriptContent, new JexlContextMap(parametersCallback));
    }

    public void executeQuery(Resource queryContent, ParametersCallback parametersCallback, QueryCallback queryCallback) throws ProviderException {
        this.run(queryContent, new JexlContextMap(parametersCallback, queryCallback));
    }

    private void run(Resource resource, JexlContextMap ctx) {
        Script script = this.cache.get(resource);
        if (script == null) {
            String s;
            try {
                s = IOUtils.toString((Reader)resource.open());
            }
            catch (IOException e) {
                throw new JexlProviderException("Unable to open resource", e);
            }
            try {
                script = ScriptFactory.createScript((String)s);
                this.cache.put(resource, script);
            }
            catch (Exception e) {
                throw new JexlProviderException("Failed to compile JEXL script", e);
            }
        }
        try {
            script.execute((JexlContext)ctx);
        }
        catch (Exception e) {
            throw new JexlProviderException("Failed to execute JEXL script", e);
        }
    }

    public void close() throws ProviderException {
        this.cache = null;
    }
}

