/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.ldap.ldif;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.Control;
import scriptella.driver.ldap.ldif.LdifParseException;
import scriptella.driver.ldap.ldif.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entry {
    private int changeType = 0;
    private List<ModificationItem> modificationList = new ArrayList<ModificationItem>();
    private Map<String, ModificationItem> modificationItems = new HashMap<String, ModificationItem>();
    private String dn;
    private String newSuperior;
    private String newRdn;
    private boolean deleteOldRdn;
    private BasicAttributes attributeList = new BasicAttributes(true);
    public static final int ADD = 0;
    public static final int MODIFY = 1;
    public static final int MODDN = 2;
    public static final int MODRDN = 3;
    public static final int DELETE = 4;
    private Control control;

    public void setDn(String dn) {
        this.dn = dn;
    }

    public void setChangeType(int changeType) {
        this.changeType = changeType;
    }

    public void setChangeType(String changeType) {
        if ("add".equals(changeType)) {
            this.changeType = 0;
        } else if ("modify".equals(changeType)) {
            this.changeType = 1;
        } else if ("moddn".equals(changeType)) {
            this.changeType = 2;
        } else if ("modrdn".equals(changeType)) {
            this.changeType = 3;
        } else if ("delete".equals(changeType)) {
            this.changeType = 4;
        }
    }

    public void addModificationItem(int modOp, String id, Object value) {
        if (this.changeType == 1) {
            BasicAttribute attr = new BasicAttribute(id, value);
            if (this.modificationItems.containsKey(id)) {
                ModificationItem item = this.modificationItems.get(id);
                if (item.getModificationOp() != modOp) {
                    throw new LdifParseException("Bad modification");
                }
                Attribute attribute = item.getAttribute();
                attribute.add(value);
            } else {
                ModificationItem item = new ModificationItem(modOp, attr);
                this.modificationList.add(item);
                this.modificationItems.put(id, item);
            }
        }
    }

    public void addAttribute(Attribute attr) {
        this.attributeList.put(attr);
    }

    public void addAttribute(String id, Object value) {
        Attribute attr = this.get(id);
        if (attr != null) {
            attr.add(value);
        } else {
            this.attributeList.put(id, value);
        }
    }

    public void putAttribute(String id, Object value) {
        Attribute attribute = this.attributeList.get(id);
        if (attribute != null) {
            attribute.add(value);
        } else {
            this.attributeList.put(id, value);
        }
    }

    public int getChangeType() {
        return this.changeType;
    }

    public List<ModificationItem> getModificationItems() {
        return this.modificationList;
    }

    public String getDn() {
        return this.dn;
    }

    public int size() {
        return this.modificationList.size();
    }

    public Attribute get(String attributeId) {
        if ("dn".equalsIgnoreCase(attributeId)) {
            return new BasicAttribute("dn", this.dn);
        }
        return this.attributeList.get(attributeId);
    }

    public Attributes getAttributes() {
        if (this.isEntry()) {
            return this.attributeList;
        }
        return null;
    }

    public boolean isDeleteOldRdn() {
        return this.deleteOldRdn;
    }

    public void setDeleteOldRdn(boolean deleteOldRdn) {
        this.deleteOldRdn = deleteOldRdn;
    }

    public String getNewRdn() {
        return this.newRdn;
    }

    public void setNewRdn(String newRdn) {
        this.newRdn = newRdn;
    }

    public String getNewSuperior() {
        return this.newSuperior;
    }

    public void setNewSuperior(String newSuperior) {
        this.newSuperior = newSuperior;
    }

    public boolean isChangeAdd() {
        return this.changeType == 0;
    }

    public boolean isChangeDelete() {
        return this.changeType == 4;
    }

    public boolean isChangeModDn() {
        return this.changeType == 2;
    }

    public boolean isChangeModRdn() {
        return this.changeType == 3;
    }

    public boolean isChangeModify() {
        return this.changeType == 1;
    }

    public boolean isEntry() {
        return this.changeType == 0;
    }

    public Control getControl() {
        return this.control;
    }

    public void setControl(Control control) {
        this.control = control;
    }

    private String dumpAttributes() {
        StringBuffer sb = new StringBuffer();
        try {
            NamingEnumeration<Attribute> attrs = this.attributeList.getAll();
            while (attrs.hasMoreElements()) {
                Attribute attribute = (Attribute)attrs.nextElement();
                sb.append("        ").append(attribute.getID()).append(":\n");
                NamingEnumeration<?> values = attribute.getAll();
                while (values.hasMoreElements()) {
                    Object value = values.nextElement();
                    if (value instanceof String) {
                        sb.append("            ").append((String)value).append('\n');
                        continue;
                    }
                    sb.append("            ").append(Utils.dumpBytes((byte[])value)).append('\n');
                }
            }
        }
        catch (NamingException ne) {
            return "";
        }
        return sb.toString();
    }

    private String dumpModificationItems() {
        StringBuffer sb = new StringBuffer();
        for (ModificationItem modif : this.modificationList) {
            sb.append("            Operation: ");
            switch (modif.getModificationOp()) {
                case 1: {
                    sb.append("ADD\n");
                    break;
                }
                case 3: {
                    sb.append("REMOVE\n");
                    break;
                }
                case 2: {
                    sb.append("REPLACE \n");
                }
            }
            Attribute attribute = modif.getAttribute();
            sb.append("                Attribute: ").append(attribute.getID()).append('\n');
            if (attribute.size() == 0) continue;
            try {
                NamingEnumeration<?> values = attribute.getAll();
                while (values.hasMoreElements()) {
                    Object value = values.nextElement();
                    if (value instanceof String) {
                        sb.append("                ").append((String)value).append('\n');
                        continue;
                    }
                    sb.append("                ").append(Utils.dumpBytes((byte[])value)).append('\n');
                }
            }
            catch (NamingException ne) {
                return "";
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Entry : ").append(this.dn).append('\n');
        if (this.control != null) {
            sb.append("    Control : ").append(this.control).append('\n');
        }
        switch (this.changeType) {
            case 0: {
                sb.append("    Change type is ADD\n");
                sb.append("        Attributes : \n");
                sb.append(this.dumpAttributes());
                break;
            }
            case 1: {
                sb.append("    Change type is MODIFY\n");
                sb.append("        Modifications : \n");
                sb.append(this.dumpModificationItems());
                break;
            }
            case 4: {
                sb.append("    Change type is DELETE\n");
                break;
            }
            case 2: 
            case 3: {
                sb.append("    Change type is ").append(this.changeType == 2 ? "MODDN\n" : "MODRDN\n");
                sb.append("    Delete old RDN : ").append(this.deleteOldRdn ? "true\n" : "false\n");
                sb.append("    New RDN : ").append(this.newRdn).append('\n');
                if (this.newSuperior == null) break;
                sb.append("    New superior : ").append(this.newSuperior).append('\n');
            }
        }
        return sb.toString();
    }
}

