/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.ldap.ldif;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import scriptella.util.IOUtils;

class Utils {
    private static final byte[] HEX_CHAR;
    public static final boolean[] DIGIT;
    private static byte[] s_codes;

    private Utils() {
    }

    public static boolean isCharASCII(char[] chars, int index, char car) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        return chars[index] == car;
    }

    public static String utf8ToString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return "";
        }
    }

    public static boolean isDigit(char[] chars, int index) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        return chars[index] <= '\u007f' && DIGIT[chars[index]];
    }

    public static byte[] base64Decode(char[] a_data) {
        int l_tempLen = a_data.length;
        for (char anA_data1 : a_data) {
            if (anA_data1 <= '\u00ff' && s_codes[anA_data1] >= 0) continue;
            --l_tempLen;
        }
        int l_len = l_tempLen / 4 * 3;
        if (l_tempLen % 4 == 3) {
            l_len += 2;
        }
        if (l_tempLen % 4 == 2) {
            ++l_len;
        }
        byte[] l_out = new byte[l_len];
        int l_shift = 0;
        int l_accum = 0;
        int l_index = 0;
        for (char anA_data : a_data) {
            int l_value;
            int n = l_value = anA_data > '\u00ff' ? -1 : s_codes[anA_data];
            if (l_value < 0) continue;
            l_accum <<= 6;
            l_accum |= l_value;
            if ((l_shift += 6) < 8) continue;
            l_out[l_index++] = (byte)(l_accum >> (l_shift -= 8) & 0xFF);
        }
        if (l_index != l_out.length) {
            throw new Error("Miscalculated data length (wrote " + l_index + " instead of " + l_out.length + ")");
        }
        return l_out;
    }

    public static String dumpBytes(byte[] buffer) {
        if (buffer == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(2 + buffer.length * 2);
        for (byte b : buffer) {
            sb.append("0x").append((char)HEX_CHAR[(b & 0xF0) >> 4]).append((char)HEX_CHAR[b & 0xF]).append(" ");
        }
        return sb.toString();
    }

    public static byte[] toByteArray(InputStream is, long maxLength) throws IOException {
        return IOUtils.toByteArray((InputStream)is, (long)maxLength);
    }

    static {
        int ii;
        HEX_CHAR = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        DIGIT = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        s_codes = new byte[256];
        for (ii = 0; ii < 256; ++ii) {
            Utils.s_codes[ii] = -1;
        }
        for (ii = 65; ii <= 90; ++ii) {
            Utils.s_codes[ii] = (byte)(ii - 65);
        }
        for (ii = 97; ii <= 122; ++ii) {
            Utils.s_codes[ii] = (byte)(26 + ii - 97);
        }
        for (ii = 48; ii <= 57; ++ii) {
            Utils.s_codes[ii] = (byte)(52 + ii - 48);
        }
        Utils.s_codes[43] = 62;
        Utils.s_codes[47] = 63;
    }
}

