/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.lucene;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.IndexReader;
import scriptella.driver.lucene.Driver;
import scriptella.driver.lucene.LuceneProviderException;
import scriptella.driver.lucene.LuceneQuery;
import scriptella.driver.text.TextProviderException;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ConnectionParameters;
import scriptella.spi.ParametersCallback;
import scriptella.spi.ProviderException;
import scriptella.spi.QueryCallback;
import scriptella.spi.Resource;
import scriptella.util.IOUtils;

public class LuceneConnection
extends AbstractConnection {
    private static final String[] EMPTY_ARRAY = new String[0];
    private URL url;
    private Set<String> fields;
    private static final String DEFAULT_FIELD = "contents";
    private Boolean useMultiFieldQueryParser;
    private Boolean useLowercaseExpandedTerms;

    public LuceneConnection(ConnectionParameters parameters) {
        super(Driver.DIALECT_IDENTIFIER, parameters);
        this.url = parameters.getResolvedUrl();
        this.parseFields((String)parameters.getProperty("fields"));
        this.useMultiFieldQueryParser = parameters.getBooleanProperty("useMultiFieldQueryParser", false);
        this.useLowercaseExpandedTerms = parameters.getBooleanProperty("useLowercaseExpandedTerms", true);
    }

    public void executeScript(Resource scriptContent, ParametersCallback parametersCallback) throws ProviderException {
        throw new UnsupportedOperationException("Script execution is not supported yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void executeQuery(Resource queryContent, ParametersCallback parametersCallback, QueryCallback queryCallback) throws ProviderException {
        Reader r;
        LuceneQuery query = null;
        try {
            r = queryContent.open();
        }
        catch (IOException e) {
            throw new TextProviderException("Cannot open a query for reading", e);
        }
        try {
            query = new LuceneQuery(this.url.getFile(), parametersCallback, queryCallback);
            query.execute(r, this.fields, this.useMultiFieldQueryParser, this.useLowercaseExpandedTerms);
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(query);
            throw throwable;
        }
        IOUtils.closeSilently((Closeable)query);
    }

    public void close() throws ProviderException {
    }

    private void parseFields(String s) {
        if (s == null) {
            this.fields = new TreeSet<String>();
            this.fields.add(DEFAULT_FIELD);
        } else {
            String[] strings = (' ' + s + ' ').split(",");
            this.fields = new TreeSet<String>();
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = strings[i].trim();
                if ("".equals(strings[i])) {
                    this.fields.add(DEFAULT_FIELD);
                    continue;
                }
                if ("*".contains(strings[i])) {
                    try {
                        IndexReader ir = IndexReader.open((String)this.url.getFile());
                        this.fields.addAll(ir.getFieldNames(IndexReader.FieldOption.INDEXED));
                        continue;
                    }
                    catch (IOException e) {
                        throw new LuceneProviderException("Failed to open lucene index.", e);
                    }
                }
                this.fields.add(strings[i]);
            }
        }
    }
}

