/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.lucene;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import scriptella.driver.lucene.LuceneProviderException;
import scriptella.expression.PropertiesSubstitutor;
import scriptella.spi.ParametersCallback;
import scriptella.spi.QueryCallback;
import scriptella.util.ExceptionUtils;
import scriptella.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneQuery
implements ParametersCallback,
Closeable {
    private static final Logger LOG = Logger.getLogger(LuceneQuery.class.getName());
    private PropertiesSubstitutor substitutor = new PropertiesSubstitutor();
    private String indexPath;
    private Document result;
    private QueryCallback queryCallback;

    public LuceneQuery(String indexPath, ParametersCallback parametersCallback, QueryCallback queryCallback) {
        this.indexPath = indexPath;
        this.substitutor = new PropertiesSubstitutor(parametersCallback);
        this.queryCallback = queryCallback;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(Reader queryReader, Collection<String> fields, Boolean useMultiFieldParser, Boolean useLowercaseExpandedTerms) {
        IndexReader ir = null;
        IndexSearcher searcher = null;
        try {
            String queryContent;
            try {
                ir = IndexReader.open((String)this.indexPath);
            }
            catch (IOException e) {
                throw new LuceneProviderException("Failed to open index " + this.indexPath, e);
            }
            searcher = new IndexSearcher(ir);
            StandardAnalyzer analyzer = new StandardAnalyzer();
            try {
                queryContent = IOUtils.toString((Reader)queryReader);
            }
            catch (IOException e) {
                throw new LuceneProviderException("Failed to load query content.", e);
            }
            if (useMultiFieldParser.booleanValue()) {
                MultiFieldQueryParser p = new MultiFieldQueryParser(fields.toArray(new String[fields.size()]), (Analyzer)analyzer);
                p.setLowercaseExpandedTerms(useLowercaseExpandedTerms.booleanValue());
                try {
                    this.iterate(searcher.search(p.parse(queryContent)));
                    return;
                }
                catch (IOException e) {
                    throw new LuceneProviderException("Failed to search query.", e);
                }
            }
            for (String field : fields) {
                QueryParser parser = new QueryParser(field, (Analyzer)analyzer);
                parser.setLowercaseExpandedTerms(useLowercaseExpandedTerms.booleanValue());
                try {
                    Query query = parser.parse(queryContent);
                    Hits hits = searcher.search(query);
                    this.iterate(hits);
                }
                catch (IOException e) {
                    throw new LuceneProviderException("Failed to search query.", e);
                    return;
                }
            }
        }
        catch (ParseException e) {
            throw new LuceneProviderException("Failed to parse query.", e);
        }
        finally {
            IOUtils.closeSilently((Closeable)queryReader);
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (Exception e) {
                    ExceptionUtils.ignoreThrowable((Throwable)e);
                }
            }
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (Exception e) {
                    ExceptionUtils.ignoreThrowable((Throwable)e);
                }
            }
        }
    }

    void iterate(Hits hits) {
        for (int i = 0; i < hits.length(); ++i) {
            try {
                this.result = hits.doc(i);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Processing search result: " + this.result);
                }
                this.queryCallback.processRow((ParametersCallback)this);
                continue;
            }
            catch (IOException e) {
                throw new LuceneProviderException("Failed to get query result.", e);
            }
        }
    }

    public Object getParameter(String name) {
        String res = this.result.get(name);
        if (res != null) {
            return res;
        }
        return this.substitutor.getParameters().getParameter(name);
    }

    @Override
    public void close() throws IOException {
        this.substitutor = null;
        this.queryCallback = null;
        this.result = null;
    }
}

