/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.script;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import scriptella.configuration.ConfigurationException;
import scriptella.driver.script.BindingsParametersCallback;
import scriptella.driver.script.ScriptProviderException;
import scriptella.expression.LineIterator;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ConnectionParameters;
import scriptella.spi.DialectIdentifier;
import scriptella.spi.ParametersCallback;
import scriptella.spi.ProviderException;
import scriptella.spi.QueryCallback;
import scriptella.spi.Resource;
import scriptella.util.ExceptionUtils;
import scriptella.util.IOUtils;
import scriptella.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptConnection
extends AbstractConnection {
    private static final Logger LOG = Logger.getLogger(ScriptConnection.class.getName());
    private Map<Resource, CompiledScript> cache;
    private ScriptEngine engine;
    private Compilable compiler;
    private String encoding;
    private URL url;
    private Writer out;
    static final String LANGUAGE = "language";
    static final String ENCODING = "encoding";

    public ScriptConnection(ConnectionParameters parameters) {
        super(parameters);
        String lang = parameters.getStringProperty(LANGUAGE);
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager(ScriptConnection.class.getClassLoader());
        if (StringUtils.isEmpty((CharSequence)lang)) {
            LOG.fine("Script language was not specified. JavaScript is default.");
            lang = "js";
        }
        this.engine = scriptEngineManager.getEngineByName(lang);
        if (this.engine == null) {
            throw new ConfigurationException("Specified language=" + lang + " not supported. Available values are: " + ScriptConnection.getAvailableEngines(scriptEngineManager));
        }
        if (this.engine instanceof Compilable) {
            this.compiler = (Compilable)((Object)this.engine);
            this.cache = new IdentityHashMap<Resource, CompiledScript>();
        } else {
            LOG.info("Engine " + this.engine.getFactory().getEngineName() + " does not support compilation. Running in interpreted mode.");
        }
        if (!StringUtils.isEmpty((CharSequence)parameters.getUrl())) {
            this.url = parameters.getResolvedUrl();
            ScriptContext ctx = this.engine.getContext();
            ctx.setReader(new LazyReader());
            ctx.setWriter(new PrintWriter(new LazyWriter()));
        }
        this.encoding = parameters.getCharsetProperty(ENCODING);
        ScriptEngineFactory f = this.engine.getFactory();
        this.setDialectIdentifier(new DialectIdentifier(f.getLanguageName(), f.getLanguageVersion()));
    }

    static List<List<String>> getAvailableEngines(ScriptEngineManager manager) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        for (ScriptEngineFactory scriptEngineFactory : manager.getEngineFactories()) {
            list.add(scriptEngineFactory.getNames());
        }
        return list;
    }

    public void executeScript(Resource scriptContent, ParametersCallback parametersCallback) throws ScriptProviderException, ConfigurationException {
        this.run(scriptContent, new BindingsParametersCallback(parametersCallback));
    }

    public void executeQuery(Resource queryContent, ParametersCallback parametersCallback, QueryCallback queryCallback) throws ScriptProviderException, ConfigurationException {
        this.run(queryContent, new BindingsParametersCallback(parametersCallback, queryCallback));
    }

    private void run(Resource resource, BindingsParametersCallback parametersCallback) {
        try {
            if (this.compiler == null) {
                this.engine.eval(resource.open(), (Bindings)parametersCallback);
                return;
            }
            CompiledScript script = this.cache.get(resource);
            if (script == null) {
                try {
                    script = this.compiler.compile(resource.open());
                    this.cache.put(resource, script);
                }
                catch (ScriptException e) {
                    throw new ScriptProviderException("Failed to compile script", e, ScriptConnection.getErrorStatement(resource, e));
                }
            }
            script.eval(parametersCallback);
        }
        catch (IOException e) {
            throw new ScriptProviderException("Failed to open script for reading", e);
        }
        catch (ScriptException e) {
            throw new ScriptProviderException("Failed to execute script", e, ScriptConnection.getErrorStatement(resource, e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getErrorStatement(Resource resource, ScriptException exception) {
        String string;
        LineIterator it = null;
        try {
            it = new LineIterator(resource.open());
            string = it.getLineAt(exception.getLineNumber() - 1);
        }
        catch (IOException e) {
            try {
                ExceptionUtils.ignoreThrowable((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(it);
                throw throwable;
            }
            IOUtils.closeSilently((Closeable)it);
            return null;
        }
        IOUtils.closeSilently((Closeable)it);
        return string;
    }

    public void close() throws ProviderException {
        this.cache = null;
    }

    final class LazyWriter
    extends Writer {
        LazyWriter() {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (ScriptConnection.this.out == null) {
                ScriptConnection.this.out = IOUtils.getWriter((OutputStream)IOUtils.getOutputStream((URL)ScriptConnection.this.url), (String)ScriptConnection.this.encoding);
            }
            ScriptConnection.this.out.write(cbuf, off, len);
        }

        public void flush() throws IOException {
            if (ScriptConnection.this.out != null) {
                ScriptConnection.this.out.flush();
            }
        }

        public void close() throws IOException {
            if (ScriptConnection.this.out != null) {
                ScriptConnection.this.out.close();
            }
        }
    }

    final class LazyReader
    extends Reader {
        private Reader r;

        LazyReader() {
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.r == null) {
                this.r = IOUtils.getReader((InputStream)ScriptConnection.this.url.openStream(), (String)ScriptConnection.this.encoding);
            }
            return this.r.read(cbuf, off, len);
        }

        public void close() throws IOException {
            if (this.r != null) {
                this.r.close();
            }
        }
    }
}

