/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.scriptella;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import scriptella.configuration.ConfigurationFactory;
import scriptella.driver.scriptella.Driver;
import scriptella.driver.scriptella.ScriptellaProviderException;
import scriptella.execution.EtlExecutor;
import scriptella.execution.EtlExecutorException;
import scriptella.execution.ExecutionStatistics;
import scriptella.expression.LineIterator;
import scriptella.expression.PropertiesSubstitutor;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ConnectionParameters;
import scriptella.spi.DriverContext;
import scriptella.spi.ParametersCallback;
import scriptella.spi.ProviderException;
import scriptella.spi.QueryCallback;
import scriptella.spi.Resource;
import scriptella.util.StringUtils;

public class ScriptellaConnection
extends AbstractConnection {
    private static final Logger LOG = Logger.getLogger(ScriptellaConnection.class.getName());
    private ConfigurationFactory configurationFactory = new ConfigurationFactory();
    private DriverContext ctx;

    public ScriptellaConnection(ConnectionParameters parameters) {
        super(Driver.DIALECT, parameters);
        this.ctx = parameters.getContext();
        if (!StringUtils.isEmpty((CharSequence)parameters.getUrl())) {
            this.execute(parameters.getResolvedUrl(), (ParametersCallback)this.ctx);
        }
    }

    public void executeScript(Resource scriptContent, ParametersCallback parametersCallback) throws ProviderException {
        LineIterator it;
        try {
            it = new LineIterator(scriptContent.open(), new PropertiesSubstitutor(parametersCallback), true);
        }
        catch (IOException e) {
            throw new ScriptellaProviderException("Unable to open script", e);
        }
        while (it.hasNext()) {
            String uri = it.next();
            if (StringUtils.isEmpty((CharSequence)uri)) continue;
            try {
                this.execute(this.ctx.resolve(uri), parametersCallback);
            }
            catch (MalformedURLException e) {
                throw new ScriptellaProviderException("Malformed URI " + uri, e);
            }
        }
    }

    private void execute(URL u, ParametersCallback callback) {
        if (this.isReadonly()) {
            LOG.info("Readonly Mode - Skipping ETL file " + u);
        } else {
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Executing Scriptella ETL file " + u);
                }
                this.configurationFactory.setResourceURL(u);
                this.configurationFactory.setExternalParameters(callback);
                ExecutionStatistics st = new EtlExecutor(this.configurationFactory.createConfiguration()).execute();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Completed ETL file execution.\n" + st);
                }
            }
            catch (EtlExecutorException e) {
                throw new ScriptellaProviderException("Failed to execute script " + u + " : " + e.getMessage(), e);
            }
        }
    }

    public void executeQuery(Resource queryContent, ParametersCallback parametersCallback, QueryCallback queryCallback) throws ProviderException {
        throw new ScriptellaProviderException("Queries are not supported");
    }

    public void close() throws ProviderException {
    }
}

