/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.spring;

import java.io.IOException;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import scriptella.driver.spring.EtlExecutorBean;
import scriptella.interactive.ProgressIndicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchEtlExecutorBean
implements Runnable,
InitializingBean,
BeanFactoryAware {
    private BeanFactory beanFactory;
    private ProgressIndicator progressIndicator;
    private boolean jmxEnabled;
    private Map<String, ?> properties;
    private Resource[] configLocations;
    private EtlExecutorBean[] etlExecutors;

    public void setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
    }

    public void setProgressIndicator(ProgressIndicator progressIndicator) {
        this.progressIndicator = progressIndicator;
    }

    public void setConfigLocations(Resource[] resources) throws IOException {
        this.configLocations = resources;
    }

    public void setProperties(Map<String, ?> properties) {
        this.properties = properties;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.configLocations == null) {
            throw new IllegalStateException("configLocations must be specified");
        }
        int n = this.configLocations.length;
        this.etlExecutors = new EtlExecutorBean[n];
        for (int i = 0; i < n; ++i) {
            EtlExecutorBean bean = new EtlExecutorBean();
            bean.setConfigLocation(this.configLocations[i]);
            bean.setProgressIndicator(this.progressIndicator);
            bean.setProperties(this.properties);
            bean.setJmxEnabled(this.jmxEnabled);
            bean.setBeanFactory(this.beanFactory);
            bean.afterPropertiesSet();
            this.etlExecutors[i] = bean;
        }
    }

    @Override
    public void run() {
        for (EtlExecutorBean executor : this.etlExecutors) {
            executor.run();
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

