/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.spring;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.beans.factory.access.SingletonBeanFactoryLocator;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.io.Resource;
import scriptella.configuration.ConfigurationFactory;
import scriptella.execution.EtlExecutor;
import scriptella.execution.EtlExecutorException;
import scriptella.execution.ExecutionStatistics;
import scriptella.interactive.ProgressIndicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EtlExecutorBean
extends EtlExecutor
implements InitializingBean,
BeanFactoryAware {
    private static final String BEAN_FACTORY_XML_PATH = "classpath:scriptella/driver/spring/beanFactory.xml";
    private static final String FACTORY_BEAN_NAME = "scriptella.driver.spring.factory";
    private static final String THREAD_LOCAL_BEAN_NAME = "scriptella.driver.spring.threadLocal";
    private BeanFactory beanFactory;
    private ProgressIndicator progressIndicator;
    private boolean autostart;
    private Map<String, ?> properties;
    private URL configLocation;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setAutostart(boolean autostart) {
        this.autostart = autostart;
    }

    public void setProgressIndicator(ProgressIndicator progressIndicator) {
        this.progressIndicator = progressIndicator;
    }

    public void setConfigLocation(Resource resource) throws IOException {
        this.configLocation = resource.getURL();
    }

    public Map<String, ?> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, ?> properties) {
        this.properties = properties;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getConfiguration() == null) {
            if (this.configLocation == null) {
                throw new IllegalStateException("configLocation must be specified");
            }
            ConfigurationFactory cf = new ConfigurationFactory();
            cf.setResourceURL(this.configLocation);
            cf.setExternalParameters(this.properties);
            this.setConfiguration(cf.createConfiguration());
        }
        if (this.autostart) {
            this.execute();
        }
    }

    public ExecutionStatistics call() throws EtlExecutorException {
        return this.execute();
    }

    public ExecutionStatistics execute() throws EtlExecutorException {
        if (this.progressIndicator != null) {
            return this.execute(this.progressIndicator);
        }
        return super.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionStatistics execute(ProgressIndicator indicator) throws EtlExecutorException {
        EtlExecutorBean.setContextBeanFactory(this.beanFactory);
        try {
            ExecutionStatistics executionStatistics = super.execute(indicator);
            return executionStatistics;
        }
        finally {
            EtlExecutorBean.setContextBeanFactory(null);
        }
    }

    private static ThreadLocal<BeanFactory> getGlobalThreadLocal() {
        BeanFactoryLocator locator = SingletonBeanFactoryLocator.getInstance((String)BEAN_FACTORY_XML_PATH);
        BeanFactoryReference ref = locator.useBeanFactory(FACTORY_BEAN_NAME);
        StaticApplicationContext ctx = (StaticApplicationContext)ref.getFactory();
        if (!ctx.containsBean(THREAD_LOCAL_BEAN_NAME)) {
            ctx.registerSingleton(THREAD_LOCAL_BEAN_NAME, ThreadLocal.class);
        }
        return (ThreadLocal)ctx.getBean(THREAD_LOCAL_BEAN_NAME);
    }

    private static synchronized void setContextBeanFactory(BeanFactory f) {
        EtlExecutorBean.getGlobalThreadLocal().set(f);
    }

    static synchronized BeanFactory getContextBeanFactory() {
        ThreadLocal<BeanFactory> threadLocal = EtlExecutorBean.getGlobalThreadLocal();
        BeanFactory f = threadLocal.get();
        if (f == null) {
            throw new IllegalStateException("No beanfactory associated with the current thread");
        }
        return f;
    }
}

