/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import scriptella.driver.text.ConsoleAdapters;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ConnectionParameters;
import scriptella.spi.DialectIdentifier;
import scriptella.util.IOUtils;

public abstract class AbstractTextConnection
extends AbstractConnection {
    protected final String encoding;
    protected final boolean trim;
    protected final boolean flush;
    protected final URL url;
    protected final String eol;
    protected final int skipLines;
    protected final String nullString;
    public static final String ENCODING = "encoding";
    public static final String EOL = "eol";
    public static final String TRIM = "trim";
    public static final String FLUSH = "flush";
    public static final String SKIP_LINES = "skip_lines";
    public static final String NULL_STRING = "null_string";

    protected AbstractTextConnection() {
        this.encoding = null;
        this.trim = false;
        this.flush = false;
        this.url = null;
        this.eol = "\n";
        this.skipLines = 0;
        this.nullString = null;
    }

    protected AbstractTextConnection(DialectIdentifier dialectIdentifier, ConnectionParameters parameters) {
        super(dialectIdentifier, parameters);
        this.url = parameters.getUrl() == null ? null : parameters.getResolvedUrl();
        this.encoding = parameters.getCharsetProperty(ENCODING);
        this.trim = parameters.getBooleanProperty(TRIM, true);
        this.flush = this.url == null || parameters.getBooleanProperty(FLUSH, false);
        String eolStr = parameters.getStringProperty(EOL);
        this.eol = eolStr != null ? eolStr : "\n";
        this.skipLines = parameters.getIntegerProperty(SKIP_LINES, 0);
        this.nullString = parameters.getStringProperty(NULL_STRING);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getEol() {
        return this.eol;
    }

    protected Writer newOutputWriter() throws IOException {
        return this.url == null ? ConsoleAdapters.getConsoleWriter(this.encoding) : IOUtils.getWriter((OutputStream)IOUtils.getOutputStream((URL)this.url), (String)this.encoding);
    }

    protected Reader newInputReader() throws IOException {
        return this.url == null ? ConsoleAdapters.getConsoleReader(this.encoding) : IOUtils.getReader((InputStream)this.url.openStream(), (String)this.encoding);
    }
}

