/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.text;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import scriptella.core.EtlCancelledException;
import scriptella.driver.text.TextProviderException;
import scriptella.expression.PropertiesSubstitutor;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ParametersCallback;
import scriptella.util.IOUtils;

public class TextScriptExecutor
implements Closeable,
Flushable {
    private BufferedWriter out;
    private boolean trim;
    private String eol;
    private PropertiesSubstitutor ps = new PropertiesSubstitutor();

    public TextScriptExecutor(Writer out, boolean trim, String eol, String nullString) {
        this.ps.setNullString(nullString);
        this.out = IOUtils.asBuffered((Writer)out);
        this.trim = trim;
        this.eol = eol;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(Reader reader, ParametersCallback pc, AbstractConnection.StatementCounter counter) {
        this.ps.setParameters(pc);
        BufferedReader r = IOUtils.asBuffered((Reader)reader);
        try {
            String line;
            while ((line = r.readLine()) != null) {
                EtlCancelledException.checkEtlCancelled();
                if (this.trim) {
                    line = line.trim();
                }
                if (this.trim && line.length() <= 0) continue;
                try {
                    this.out.write(this.ps.substitute(line));
                    this.out.write(this.eol);
                    ++counter.statements;
                }
                catch (IOException e) {
                    throw new TextProviderException("Failed writing to a text file", e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new TextProviderException("Failed reading a script file", e);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        IOUtils.closeSilently((Closeable)this.out);
        this.out = null;
        this.ps = null;
    }
}

