/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.velocity;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogSystem;
import scriptella.driver.text.AbstractTextConnection;
import scriptella.driver.velocity.Driver;
import scriptella.driver.velocity.VelocityProviderException;
import scriptella.spi.ConnectionParameters;
import scriptella.spi.ParametersCallback;
import scriptella.spi.ProviderException;
import scriptella.spi.QueryCallback;
import scriptella.spi.Resource;
import scriptella.util.IOUtils;

public class VelocityConnection
extends AbstractTextConnection {
    public static final String OUTPUT_ENCODING = "output.encoding";
    private final VelocityEngine engine = new VelocityEngine();
    private final VelocityContextAdapter adapter;
    private Writer writer;
    static final LogSystem LOG_SYSTEM = new LogSystem(){

        public void init(RuntimeServices rs) {
        }

        public void logVelocityMessage(int level, String message) {
            Level lev;
            if (level < 0) {
                return;
            }
            switch (level) {
                case 0: {
                    lev = Level.FINE;
                    break;
                }
                case 1: {
                    lev = Level.CONFIG;
                    break;
                }
                case 3: {
                    lev = Level.WARNING;
                    break;
                }
                default: {
                    lev = Level.INFO;
                }
            }
            if (Driver.LOG.isLoggable(lev)) {
                Driver.LOG.log(lev, "Engine: " + message);
            }
        }
    };

    public VelocityConnection(ConnectionParameters parameters) {
        super(Driver.DIALECT, parameters);
        this.engine.setProperty("runtime.log.logsystem", (Object)LOG_SYSTEM);
        this.engine.setProperty("velocimacro.library", (Object)"");
        try {
            this.engine.init();
        }
        catch (Exception e) {
            throw new VelocityProviderException("Unable to initialize engine", e);
        }
        this.adapter = new VelocityContextAdapter();
    }

    public void executeScript(Resource scriptContent, ParametersCallback parametersCallback) throws ProviderException {
        this.adapter.setCallback(parametersCallback);
        Reader reader = null;
        try {
            reader = scriptContent.open();
            Writer w = this.getWriter();
            this.engine.evaluate((Context)this.adapter, w, this.url == null ? "System.out" : this.url.getFile(), reader);
            if (this.flush) {
                w.flush();
            }
        }
        catch (Exception e) {
            throw new VelocityProviderException("Unable to execute script", e);
        }
        finally {
            this.adapter.setCallback(null);
            IOUtils.closeSilently((Closeable)reader);
        }
    }

    public void executeQuery(Resource queryContent, ParametersCallback parametersCallback, QueryCallback queryCallback) throws ProviderException {
        throw new UnsupportedOperationException("Query execution is not supported yet");
    }

    private Writer getWriter() {
        if (this.writer == null) {
            try {
                this.writer = IOUtils.asBuffered((Writer)this.newOutputWriter());
            }
            catch (IOException e) {
                throw new VelocityProviderException("Unable to open URL " + this.url + " for output", e);
            }
        }
        return this.writer;
    }

    public synchronized void close() throws ProviderException {
        if (this.writer != null) {
            IOUtils.closeSilently((Closeable)this.writer);
            this.writer = null;
        }
    }

    private static class VelocityContextAdapter
    implements Context {
        private ParametersCallback callback;

        private VelocityContextAdapter() {
        }

        public void setCallback(ParametersCallback callback) {
            this.callback = callback;
        }

        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object get(String key) {
            return this.callback.getParameter(key);
        }

        public boolean containsKey(Object key) {
            return false;
        }

        public Object[] getKeys() {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }
    }
}

