/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.xpath;

import java.net.URL;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import scriptella.driver.xpath.Driver;
import scriptella.driver.xpath.XPathExpressionCompiler;
import scriptella.driver.xpath.XPathProviderException;
import scriptella.driver.xpath.XPathQueryExecutor;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ConnectionParameters;
import scriptella.spi.ParametersCallback;
import scriptella.spi.ProviderException;
import scriptella.spi.QueryCallback;
import scriptella.spi.Resource;

public class XPathConnection
extends AbstractConnection {
    private Map<Resource, XPathQueryExecutor> queriesCache = new IdentityHashMap<Resource, XPathQueryExecutor>();
    private XPathExpressionCompiler compiler = new XPathExpressionCompiler();
    private Document document;
    private URL url;
    static final DocumentBuilderFactory DBF = DocumentBuilderFactory.newInstance();

    protected XPathConnection() {
    }

    public XPathConnection(ConnectionParameters parameters) {
        super(Driver.DIALECT, parameters);
        this.url = parameters.getResolvedUrl();
    }

    public void executeScript(Resource scriptContent, ParametersCallback parametersCallback) throws ProviderException {
        throw new XPathProviderException("Script execution is not supported yet");
    }

    public void executeQuery(Resource queryContent, ParametersCallback parametersCallback, QueryCallback queryCallback) throws ProviderException {
        XPathQueryExecutor exec = this.queriesCache.get(queryContent);
        if (exec == null) {
            exec = new XPathQueryExecutor(this.getDocument(), queryContent, this.compiler, this.counter);
            this.queriesCache.put(queryContent, exec);
        }
        exec.execute(queryCallback, parametersCallback);
    }

    private Document getDocument() {
        if (this.document == null) {
            try {
                this.document = DBF.newDocumentBuilder().parse(new InputSource(this.url.toString()));
            }
            catch (Exception e) {
                throw new XPathProviderException("Unable to parse document " + this.url, e);
            }
        }
        return this.document;
    }

    public void close() throws ProviderException {
        this.queriesCache = null;
        this.document = null;
    }
}

