/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.xpath;

import java.io.IOException;
import java.io.Reader;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import scriptella.driver.xpath.XPathExpressionCompiler;
import scriptella.driver.xpath.XPathProviderException;
import scriptella.expression.PropertiesSubstitutor;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ParametersCallback;
import scriptella.spi.QueryCallback;
import scriptella.spi.Resource;
import scriptella.util.IOUtils;
import scriptella.util.StringUtils;

public class XPathQueryExecutor
implements ParametersCallback {
    private Node node;
    private PropertiesSubstitutor substitutor = new PropertiesSubstitutor();
    private Document document;
    private String expressionStr;
    private XPathExpressionCompiler compiler;
    private AbstractConnection.StatementCounter counter;

    public XPathQueryExecutor(Document document, Resource xpathResource, XPathExpressionCompiler compiler, AbstractConnection.StatementCounter counter) {
        this.document = document;
        this.compiler = compiler;
        this.counter = counter;
        try {
            this.expressionStr = IOUtils.toString((Reader)xpathResource.open());
        }
        catch (IOException e) {
            throw new XPathProviderException("Unable to read XPath query content");
        }
    }

    public void execute(QueryCallback queryCallback, ParametersCallback parentParameters) {
        try {
            this.substitutor.setParameters(parentParameters);
            XPathExpression xpathExpression = this.compiler.compile(this.substitutor.substitute(this.expressionStr));
            NodeList nList = (NodeList)xpathExpression.evaluate(this.document, XPathConstants.NODESET);
            ++this.counter.statements;
            int n = nList.getLength();
            for (int i = 0; i < n; ++i) {
                this.node = nList.item(i);
                queryCallback.processRow((ParametersCallback)this);
            }
        }
        catch (XPathExpressionException e) {
            throw new XPathProviderException("Failed to evaluate XPath query", e);
        }
        finally {
            this.substitutor.setParameters(null);
        }
    }

    public Object getParameter(String name) {
        Element element;
        NodeList list;
        int n;
        String[] result = null;
        if (this.node instanceof Element) {
            Node item = this.node.getAttributes().getNamedItem(name);
            String[] stringArray = result = item == null ? null : StringUtils.nullsafeTrim((CharSequence)item.getNodeValue());
        }
        if (result == null && name.equals(this.node.getNodeName())) {
            result = StringUtils.nullsafeTrim((CharSequence)this.node.getTextContent());
        }
        if (result == null && this.node instanceof Element && (n = (list = (element = (Element)this.node).getElementsByTagName(name)).getLength()) > 0) {
            String[] r = new String[n];
            for (int i = 0; i < n; ++i) {
                r[i] = StringUtils.nullsafeTrim((CharSequence)list.item(i).getTextContent());
            }
            result = r.length > 1 ? r : r[0];
        }
        return result == null ? this.substitutor.getParameters().getParameter(name) : result;
    }
}

