/*
 * Decompiled with CFR 0.152.
 */
package flex;

import com.mybatisflex.core.MybatisFlexBootstrap;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryWrapper;
import commons.DataSourceFactory;
import flex.entity.FlexAccount;
import flex.entity.table.Tables;
import flex.mapper.FlexAccountMapper;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class FlexInitializer {
    private static SqlSessionFactory sqlSessionFactory;

    public static void init() {
        DataSource dataSource = DataSourceFactory.getDataSource();
        MybatisFlexBootstrap.getInstance().setDataSource(dataSource).addMapper(FlexAccountMapper.class).start();
        sqlSessionFactory = MybatisFlexBootstrap.getInstance().getSqlSessionFactory();
    }

    public static FlexAccount selectOne() {
        try (SqlSession sqlSession = sqlSessionFactory.openSession();){
            FlexAccountMapper mapper = (FlexAccountMapper)sqlSession.getMapper(FlexAccountMapper.class);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.where(Tables.FLEX_ACCOUNT.ID.ge((Object)100).or(Tables.FLEX_ACCOUNT.USER_NAME.eq((Object)("admin" + ThreadLocalRandom.current().nextInt(10000)))));
            FlexAccount flexAccount = (FlexAccount)mapper.selectOneByQuery(queryWrapper);
            return flexAccount;
        }
    }

    public static List<FlexAccount> selectTop10() {
        try (SqlSession sqlSession = sqlSessionFactory.openSession();){
            FlexAccountMapper mapper = (FlexAccountMapper)sqlSession.getMapper(FlexAccountMapper.class);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.where(Tables.FLEX_ACCOUNT.ID.ge((Object)100).or(Tables.FLEX_ACCOUNT.USER_NAME.eq((Object)("admin" + ThreadLocalRandom.current().nextInt(10000))))).limit(Integer.valueOf(10));
            List list = mapper.selectListByQuery(queryWrapper);
            return list;
        }
    }

    public static List<FlexAccount> selectTop10000() {
        try (SqlSession sqlSession = sqlSessionFactory.openSession();){
            FlexAccountMapper mapper = (FlexAccountMapper)sqlSession.getMapper(FlexAccountMapper.class);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.where(Tables.FLEX_ACCOUNT.ID.ge((Object)100).or(Tables.FLEX_ACCOUNT.USER_NAME.eq((Object)("admin" + ThreadLocalRandom.current().nextInt(10000))))).limit(Integer.valueOf(10000));
            List list = mapper.selectListByQuery(queryWrapper);
            return list;
        }
    }

    public static Page<FlexAccount> paginate(int page, int pageSize, QueryWrapper queryWrapper) {
        try (SqlSession sqlSession = sqlSessionFactory.openSession();){
            FlexAccountMapper mapper = (FlexAccountMapper)sqlSession.getMapper(FlexAccountMapper.class);
            Page page2 = mapper.paginate(page, pageSize, 20000, queryWrapper);
            return page2;
        }
    }

    public static void update(FlexAccount flexAccount, QueryWrapper queryWrapper) {
        try (SqlSession sqlSession = sqlSessionFactory.openSession(true);){
            FlexAccountMapper mapper = (FlexAccountMapper)sqlSession.getMapper(FlexAccountMapper.class);
            mapper.updateByQuery(flexAccount, queryWrapper);
        }
    }
}

