/*
 * Decompiled with CFR 0.152.
 */
package plus;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.MybatisSqlSessionFactoryBuilder;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import commons.DataSourceFactory;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.sql.DataSource;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import plus.entity.PlusAccount;
import plus.mapper.PlusAccountMapper;

public class PlusInitializer {
    private static SqlSessionFactory sqlSessionFactory;

    public static void init() {
        DataSource dataSource = DataSourceFactory.getDataSource();
        JdbcTransactionFactory transactionFactory = new JdbcTransactionFactory();
        Environment environment = new Environment("Production", (TransactionFactory)transactionFactory, dataSource);
        MybatisConfiguration configuration = new MybatisConfiguration(environment);
        configuration.addMapper(PlusAccountMapper.class);
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        PaginationInnerInterceptor paginationInnerInterceptor = new PaginationInnerInterceptor(DbType.H2);
        paginationInnerInterceptor.setMaxLimit(Long.valueOf(20000L));
        interceptor.addInnerInterceptor((InnerInterceptor)paginationInnerInterceptor);
        interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)new TenantLineInnerInterceptor(new TenantLineHandler(){

            public Expression getTenantId() {
                return new LongValue(1L);
            }

            public boolean ignoreTable(String tableName) {
                return !"sys_user".equalsIgnoreCase(tableName);
            }
        }));
        configuration.addInterceptor((Interceptor)interceptor);
        sqlSessionFactory = new MybatisSqlSessionFactoryBuilder().build((Configuration)configuration);
    }

    public static PlusAccount selectOneWithLambda() {
        try (SqlSession sqlSession = sqlSessionFactory.openSession();){
            PlusAccountMapper mapper = (PlusAccountMapper)sqlSession.getMapper(PlusAccountMapper.class);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.ge(PlusAccount::getId, (Object)100);
            queryWrapper.or();
            queryWrapper.eq(PlusAccount::getUserName, (Object)("admin" + ThreadLocalRandom.current().nextInt(10000)));
            queryWrapper.last("limit 1");
            PlusAccount plusAccount = (PlusAccount)mapper.selectOne((Wrapper)queryWrapper);
            return plusAccount;
        }
    }

    public static PlusAccount selectOne() {
        try (SqlSession sqlSession = sqlSessionFactory.openSession();){
            PlusAccountMapper mapper = (PlusAccountMapper)sqlSession.getMapper(PlusAccountMapper.class);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.ge((Object)"id", (Object)100);
            queryWrapper.or();
            queryWrapper.eq((Object)"user_name", (Object)("admin" + ThreadLocalRandom.current().nextInt(10000)));
            queryWrapper.last("limit 1");
            PlusAccount plusAccount = (PlusAccount)mapper.selectOne((Wrapper)queryWrapper);
            return plusAccount;
        }
    }

    public static List<PlusAccount> selectTop10WithLambda() {
        try (SqlSession sqlSession = sqlSessionFactory.openSession();){
            PlusAccountMapper mapper = (PlusAccountMapper)sqlSession.getMapper(PlusAccountMapper.class);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.ge(PlusAccount::getId, (Object)100);
            queryWrapper.or();
            queryWrapper.eq(PlusAccount::getUserName, (Object)("admin" + ThreadLocalRandom.current().nextInt(10000)));
            queryWrapper.last("limit 10");
            List list = mapper.selectList((Wrapper)queryWrapper);
            return list;
        }
    }

    public static List<PlusAccount> selectTop10() {
        try (SqlSession sqlSession = sqlSessionFactory.openSession();){
            PlusAccountMapper mapper = (PlusAccountMapper)sqlSession.getMapper(PlusAccountMapper.class);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.ge((Object)"id", (Object)100);
            queryWrapper.or();
            queryWrapper.eq((Object)"user_name", (Object)("admin" + ThreadLocalRandom.current().nextInt(10000)));
            queryWrapper.last("limit 10");
            List list = mapper.selectList((Wrapper)queryWrapper);
            return list;
        }
    }

    public static List<PlusAccount> selectTop10000WithLambda() {
        try (SqlSession sqlSession = sqlSessionFactory.openSession();){
            PlusAccountMapper mapper = (PlusAccountMapper)sqlSession.getMapper(PlusAccountMapper.class);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.ge(PlusAccount::getId, (Object)100);
            queryWrapper.or();
            queryWrapper.eq(PlusAccount::getUserName, (Object)("admin" + ThreadLocalRandom.current().nextInt(10000)));
            queryWrapper.last("limit 10000");
            List list = mapper.selectList((Wrapper)queryWrapper);
            return list;
        }
    }

    public static List<PlusAccount> selectTop10000() {
        try (SqlSession sqlSession = sqlSessionFactory.openSession();){
            PlusAccountMapper mapper = (PlusAccountMapper)sqlSession.getMapper(PlusAccountMapper.class);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.ge((Object)"id", (Object)100);
            queryWrapper.or();
            queryWrapper.eq((Object)"user_name", (Object)("admin" + ThreadLocalRandom.current().nextInt(10000)));
            queryWrapper.last("limit 10000");
            List list = mapper.selectList((Wrapper)queryWrapper);
            return list;
        }
    }

    public static Page<PlusAccount> paginate(int page, int pageSize, LambdaQueryWrapper<PlusAccount> queryWrapper) {
        try (SqlSession sqlSession = sqlSessionFactory.openSession();){
            PlusAccountMapper mapper = (PlusAccountMapper)sqlSession.getMapper(PlusAccountMapper.class);
            Page p = Page.of((long)page, (long)pageSize, (long)20000L, (boolean)false);
            Page page2 = (Page)mapper.selectPage((IPage)p, (Wrapper)queryWrapper);
            return page2;
        }
    }

    public static void update(PlusAccount plusAccount, LambdaUpdateWrapper<PlusAccount> lambdaUpdateWrapper) {
        try (SqlSession sqlSession = sqlSessionFactory.openSession(true);){
            PlusAccountMapper mapper = (PlusAccountMapper)sqlSession.getMapper(PlusAccountMapper.class);
            mapper.update(plusAccount, (Wrapper)lambdaUpdateWrapper);
        }
    }
}

