/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.ftp;

import com.javaquery.ftp.Credentials;
import com.javaquery.ftp.FTPClientImpl;
import com.javaquery.ftp.FTPSClientImpl;
import com.javaquery.ftp.FTPType;
import com.javaquery.ftp.FileFilter;
import com.javaquery.ftp.FileTransferClient;
import com.javaquery.ftp.SFTPClientImpl;
import com.javaquery.ftp.exception.FTPException;
import com.javaquery.ftp.io.RemoteFile;
import java.util.List;

public class JFTPClient {
    private final FileTransferClient fileTransferClient;

    public JFTPClient(FTPType ftpType) {
        switch (ftpType) {
            case FTP: {
                this.fileTransferClient = new FTPClientImpl();
                break;
            }
            case SFTP: {
                this.fileTransferClient = new SFTPClientImpl();
                break;
            }
            case FTPS: {
                this.fileTransferClient = new FTPSClientImpl();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported FTP type: " + (Object)((Object)ftpType));
            }
        }
    }

    public void connect(Credentials credentials) throws FTPException {
        this.fileTransferClient.connect(credentials);
    }

    public void disconnect() throws FTPException {
        this.fileTransferClient.disconnect();
    }

    public List<RemoteFile> listFiles(String directoryPath, FileFilter<RemoteFile> fileFilter) throws FTPException {
        return this.fileTransferClient.listFiles(directoryPath, fileFilter);
    }

    public boolean uploadFile(String localFilePath, String remoteFilePath) throws FTPException {
        return this.fileTransferClient.uploadFile(localFilePath, remoteFilePath);
    }

    public boolean downloadFile(String remoteFilePath, String localFilePath) throws FTPException {
        return this.fileTransferClient.downloadFile(remoteFilePath, localFilePath);
    }

    public boolean deleteFile(String remoteFilePath) throws FTPException {
        return this.fileTransferClient.deleteFile(remoteFilePath);
    }
}

