/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.ftp;

import com.javaquery.ftp.Credentials;
import com.javaquery.ftp.FileFilter;
import com.javaquery.ftp.FileTransferClient;
import com.javaquery.ftp.exception.FTPException;
import com.javaquery.ftp.io.RemoteFile;
import com.javaquery.util.Is;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPClientImpl
implements FileTransferClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(FTPClientImpl.class);
    private FTPClient ftpClient;

    @Override
    public void connect(Credentials credentials) throws FTPException {
        try {
            this.ftpClient = new FTPClient();
            this.ftpClient.setConnectTimeout(credentials.getConnectTimeout());
            this.ftpClient.connect(credentials.getHost(), credentials.getPort());
            boolean login = this.ftpClient.login(credentials.getUsername(), credentials.getPassword());
            if (!login) {
                throw new FTPException("Failed to login to FTP server with provided credentials", null);
            }
            this.ftpClient.setSoTimeout(credentials.getSocketTimeout());
            this.ftpClient.enterLocalPassiveMode();
            this.ftpClient.setFileType(2);
            this.ftpClient.addProtocolCommandListener(new ProtocolCommandListener(){

                public void protocolCommandSent(ProtocolCommandEvent event) {
                    LOGGER.info(event.getMessage());
                }

                public void protocolReplyReceived(ProtocolCommandEvent event) {
                    LOGGER.info(event.getMessage());
                }
            });
        }
        catch (Exception e) {
            throw new FTPException(e.getMessage(), e);
        }
    }

    @Override
    public void disconnect() throws FTPException {
        Is.nonNull((Object)this.ftpClient, () -> {
            try {
                if (this.ftpClient.isConnected()) {
                    this.ftpClient.logout();
                    this.ftpClient.disconnect();
                }
            }
            catch (Exception e) {
                throw new FTPException(e.getMessage(), e);
            }
        });
    }

    @Override
    public List<RemoteFile> listFiles(String directoryPath, FileFilter<RemoteFile> fileFilter) throws FTPException {
        if (Is.nonNull((Object)directoryPath)) {
            ArrayList<RemoteFile> result = new ArrayList<RemoteFile>();
            try {
                FTPFile[] files;
                for (FTPFile ftpFile : files = this.ftpClient.listFiles(directoryPath)) {
                    String filepath = directoryPath.endsWith(File.separator) ? directoryPath + ftpFile.getName() : directoryPath + File.separatorChar + ftpFile.getName();
                    RemoteFile remoteFile = RemoteFile.builder().name(ftpFile.getName()).isFile(ftpFile.isFile()).isDirectory(ftpFile.isDirectory()).size(ftpFile.getSize()).timestamp(ftpFile.getTimestamp()).path(filepath).build();
                    if (Is.nonNull(fileFilter)) {
                        if (!fileFilter.accept(remoteFile)) continue;
                        result.add(remoteFile);
                        continue;
                    }
                    result.add(remoteFile);
                }
                return result;
            }
            catch (Exception e) {
                throw new FTPException(e.getMessage(), e);
            }
        }
        return null;
    }

    @Override
    public boolean uploadFile(String localFilePath, String remoteFilePath) throws FTPException {
        boolean result;
        block9: {
            result = false;
            if (Is.nonNullNonEmpty((String)localFilePath) && Is.nonNullNonEmpty((String)remoteFilePath)) {
                try {
                    File localFile = new File(localFilePath);
                    if (!localFile.exists() || !localFile.isFile()) break block9;
                    try (InputStream inputStream = Files.newInputStream(localFile.toPath(), new OpenOption[0]);){
                        result = this.ftpClient.storeFile(remoteFilePath, inputStream);
                    }
                }
                catch (Exception e) {
                    throw new FTPException(e.getMessage(), e);
                }
            }
        }
        return result;
    }

    @Override
    public boolean downloadFile(String remoteFilePath, String localFilePath) throws FTPException {
        boolean result = false;
        if (Is.nonNullNonEmpty((String)localFilePath) && Is.nonNullNonEmpty((String)remoteFilePath)) {
            try {
                File localFile = new File(localFilePath);
                try (InputStream inputStream = this.ftpClient.retrieveFileStream(remoteFilePath);){
                    if (Is.nonNull((Object)inputStream)) {
                        Files.copy(inputStream, localFile.toPath(), new CopyOption[0]);
                        result = this.ftpClient.completePendingCommand();
                    }
                }
            }
            catch (Exception e) {
                throw new FTPException(e.getMessage(), e);
            }
        }
        return result;
    }

    @Override
    public boolean deleteFile(String remoteFilePath) throws FTPException {
        boolean result = false;
        if (Is.nonNullNonEmpty((String)remoteFilePath)) {
            try {
                result = this.ftpClient.deleteFile(remoteFilePath);
            }
            catch (Exception e) {
                throw new FTPException(e.getMessage(), e);
            }
        }
        return result;
    }
}

