/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.ftp;

import com.javaquery.ftp.Credentials;
import com.javaquery.ftp.FileFilter;
import com.javaquery.ftp.FileTransferClient;
import com.javaquery.ftp.exception.FTPException;
import com.javaquery.ftp.io.RemoteFile;
import com.javaquery.util.Is;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class SFTPClientImpl
implements FileTransferClient {
    private Session session;
    private Channel channel;
    private ChannelSftp channelSftp;

    @Override
    public void connect(Credentials credentials) throws FTPException {
        try {
            JSch jsch = new JSch();
            this.session = jsch.getSession(credentials.getUsername(), credentials.getHost(), credentials.getPort());
            this.session.setPassword(credentials.getPassword());
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            this.session.connect(credentials.getConnectTimeout());
            this.session.setTimeout(credentials.getSocketTimeout());
            this.channel = this.session.openChannel("sftp");
            this.channel.connect();
            this.channelSftp = (ChannelSftp)this.channel;
        }
        catch (Exception e) {
            throw new FTPException(e.getMessage(), e);
        }
    }

    @Override
    public void disconnect() throws FTPException {
        try {
            if (this.channelSftp != null && this.channelSftp.isConnected()) {
                this.channelSftp.exit();
            }
            if (this.channel != null && this.channel.isConnected()) {
                this.channel.disconnect();
            }
            if (this.session != null && this.session.isConnected()) {
                this.session.disconnect();
            }
        }
        catch (Exception e) {
            throw new FTPException(e.getMessage(), e);
        }
    }

    @Override
    public List<RemoteFile> listFiles(String directoryPath, FileFilter<RemoteFile> fileFilter) throws FTPException {
        if (Is.nonNull((Object)directoryPath)) {
            ArrayList<RemoteFile> result = new ArrayList<RemoteFile>();
            try {
                Vector files = this.channelSftp.ls(directoryPath);
                for (ChannelSftp.LsEntry entry : files) {
                    String filepath = directoryPath.endsWith(File.separator) ? directoryPath + entry.getFilename() : directoryPath + File.separatorChar + entry.getFilename();
                    Calendar timestamp = Calendar.getInstance();
                    timestamp.setTimeInMillis((long)entry.getAttrs().getMTime() * 1000L);
                    RemoteFile remoteFile = RemoteFile.builder().name(entry.getFilename()).isFile(!entry.getAttrs().isDir()).isDirectory(entry.getAttrs().isDir()).size(entry.getAttrs().getSize()).timestamp(timestamp).path(filepath).build();
                    if (Is.nonNull(fileFilter)) {
                        if (!fileFilter.accept(remoteFile)) continue;
                        result.add(remoteFile);
                        continue;
                    }
                    result.add(remoteFile);
                }
                return result;
            }
            catch (Exception e) {
                throw new FTPException(e.getMessage(), e);
            }
        }
        return null;
    }

    @Override
    public boolean uploadFile(String localFilePath, String remoteFilePath) throws FTPException {
        boolean result = false;
        if (Is.nonNullNonEmpty((String)localFilePath) && Is.nonNullNonEmpty((String)remoteFilePath)) {
            try {
                this.channelSftp.put(localFilePath, remoteFilePath);
                result = true;
            }
            catch (Exception e) {
                throw new FTPException(e.getMessage(), e);
            }
        }
        return result;
    }

    @Override
    public boolean downloadFile(String remoteFilePath, String localFilePath) throws FTPException {
        boolean result = false;
        if (Is.nonNullNonEmpty((String)remoteFilePath) && Is.nonNullNonEmpty((String)localFilePath)) {
            try {
                this.channelSftp.get(remoteFilePath, localFilePath);
                result = true;
            }
            catch (Exception e) {
                throw new FTPException(e.getMessage(), e);
            }
        }
        return result;
    }

    @Override
    public boolean deleteFile(String remoteFilePath) throws FTPException {
        boolean result = false;
        if (Is.nonNullNonEmpty((String)remoteFilePath)) {
            try {
                this.channelSftp.rm(remoteFilePath);
                result = true;
            }
            catch (Exception e) {
                throw new FTPException(e.getMessage(), e);
            }
        }
        return result;
    }
}

