/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.util.string;

import com.javaquery.util.Objects;
import com.javaquery.util.collection.Collections;
import java.util.List;
import java.util.StringJoiner;

public final class Strings {
    public static final String EMPTY_STRING = "";
    private static final String UNSUPPORTED_ASCII_PATTERN = "[^\\x20-\\x7e]";
    private static final String UNSUPPORTED_UNICODE_PATTERN = "[\\uD83C-\\uDBFF\\uDC00-\\uDFFF]+";

    private Strings() {
    }

    public static boolean nullOrEmpty(String str) {
        return Objects.isNull(str) || str.trim().isEmpty();
    }

    public static boolean nonNullNonEmpty(String str) {
        return Objects.nonNull(str) && !str.trim().isEmpty();
    }

    public static String trimString(String str) {
        return Objects.nonNull(str) ? str.trim() : null;
    }

    public static String joinStrings(String separator, String ... strings) {
        if (Objects.nonNull(separator)) {
            StringJoiner stringJoiner = new StringJoiner(separator);
            if (Objects.nonNull(strings)) {
                for (String str : strings) {
                    if (!Strings.nonNullNonEmpty(str)) continue;
                    stringJoiner.add(str);
                }
            }
            return stringJoiner.toString();
        }
        return null;
    }

    public static String joinStringList(String separator, List<String> strings) {
        if (Objects.nonNull(separator)) {
            StringJoiner stringJoiner = new StringJoiner(separator);
            if (Collections.nonNullNonEmpty(strings)) {
                for (String str : strings) {
                    if (!Strings.nonNullNonEmpty(str)) continue;
                    stringJoiner.add(str);
                }
            }
            return stringJoiner.toString();
        }
        return null;
    }

    public static boolean optBooleanFromString(String str) {
        return "true".equalsIgnoreCase(str) || "yes".equalsIgnoreCase(str) || "y".equalsIgnoreCase(str) || "1".equalsIgnoreCase(str);
    }

    public static String removeNotSupportedASCIICharacters(String str) {
        if (Strings.nonNullNonEmpty(str)) {
            return str.replaceAll(UNSUPPORTED_ASCII_PATTERN, EMPTY_STRING);
        }
        return null;
    }

    public static String removeNotSupportedUnicodeCharacters(String str) {
        if (Strings.nonNullNonEmpty(str)) {
            return str.replaceAll(UNSUPPORTED_UNICODE_PATTERN, EMPTY_STRING);
        }
        return null;
    }
}

