/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.util.time;

import com.javaquery.util.Objects;
import com.javaquery.util.time.DateTimeFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class Dates {
    public static final TimeZone SYSTEM_TIMEZONE = TimeZone.getDefault();
    private static final Calendar CALENDAR = Calendar.getInstance();

    private Dates() {
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static Date addInDate(Date date, int type, int amount) {
        Calendar calendar = Calendar.getInstance();
        if (Objects.nonNull(date)) {
            calendar.setTime(date);
            calendar.add(type, amount);
        }
        return calendar.getTime();
    }

    public static Date addInCurrentDate(int type, int amount) {
        return Dates.addInDate(new Date(), type, amount);
    }

    public static Date increment(Date date, int type, int amount) {
        return Dates.addInDate(date, type, Math.abs(amount));
    }

    public static Date reduce(Date date, int type, int amount) {
        return Dates.addInDate(date, type, -Math.abs(amount));
    }

    private static SimpleDateFormat getSimpleDateFormat(DateTimeFormat dateTimeFormat, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateTimeFormat.getValue());
        simpleDateFormat.setTimeZone(timeZone);
        return simpleDateFormat;
    }

    public static Date parse(String date, DateTimeFormat dateTimeFormat, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat = Dates.getSimpleDateFormat(dateTimeFormat, timeZone);
        try {
            return simpleDateFormat.parse(date);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date parse(String date, DateTimeFormat dateTimeFormat) {
        return Dates.parse(date, dateTimeFormat, SYSTEM_TIMEZONE);
    }

    public static String format(Date date, DateTimeFormat dateTimeFormat, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat = Dates.getSimpleDateFormat(dateTimeFormat, timeZone);
        return simpleDateFormat.format(date);
    }

    public static String format(Date date, DateTimeFormat dateTimeFormat) {
        return Dates.format(date, dateTimeFormat, SYSTEM_TIMEZONE);
    }

    public static String addInDateAndFormat(Date date, int type, int amount, DateTimeFormat dateTimeFormat) {
        return Dates.format(Dates.addInDate(date, type, amount), dateTimeFormat);
    }

    public static long epochSeconds(Date date) {
        return date.getTime() / 1000L;
    }

    public static Date getDate(int year, int month, int day, int hour, int minute, int seconds) {
        CALENDAR.set(year, --month, day, hour, minute, seconds);
        return CALENDAR.getTime();
    }

    public static Date current() {
        return new Date();
    }

    public static Date getDate(int year, int month, int day) {
        return Dates.getDate(year, month, day, 0, 0, 0);
    }

    public static enum Month {
        JANUARY(1),
        FEBRUARY(2),
        MARCH(3),
        APRIL(4),
        MAY(5),
        JUNE(6),
        JULY(7),
        AUGUST(8),
        SEPTEMBER(9),
        OCTOBER(10),
        NOVEMBER(11),
        DECEMBER(12);

        private static final Calendar calendar;
        private final int value;

        private Month(int value) {
            this.value = value;
        }

        public static Month currentMonth() {
            return Month.values()[calendar.get(2)];
        }

        public int getValue() {
            return this.value;
        }

        static {
            calendar = Calendar.getInstance();
        }
    }
}

