/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.github.service;

import com.google.gson.reflect.TypeToken;
import com.jdroid.github.IRepositoryIdProvider;
import com.jdroid.github.User;
import com.jdroid.github.client.GitHubClient;
import com.jdroid.github.client.PagedRequest;
import com.jdroid.github.service.GitHubService;
import java.io.IOException;
import java.util.List;

public class CollaboratorService
extends GitHubService {
    public CollaboratorService() {
    }

    public CollaboratorService(GitHubClient client) {
        super(client);
    }

    public List<User> getCollaborators(IRepositoryIdProvider repository) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/collaborators");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<User>>(){}.getType());
        return this.getAll(request);
    }

    protected String createUpdateUri(IRepositoryIdProvider repository, String user) {
        String id = this.getId(repository);
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/collaborators");
        uri.append('/').append(user);
        return uri.toString();
    }

    public boolean isCollaborator(IRepositoryIdProvider repository, String user) throws IOException {
        return this.check(this.createUpdateUri(repository, user));
    }

    public void addCollaborator(IRepositoryIdProvider repository, String user) throws IOException {
        this.client.put(this.createUpdateUri(repository, user));
    }

    public void removeCollaborator(IRepositoryIdProvider repository, String user) throws IOException {
        this.client.delete(this.createUpdateUri(repository, user));
    }
}

