/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.github.service;

import com.google.gson.reflect.TypeToken;
import com.jdroid.github.IRepositoryIdProvider;
import com.jdroid.github.Milestone;
import com.jdroid.github.client.GitHubClient;
import com.jdroid.github.client.GitHubRequest;
import com.jdroid.github.client.PagedRequest;
import com.jdroid.github.service.GitHubService;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public class MilestoneService
extends GitHubService {
    public MilestoneService() {
    }

    public MilestoneService(GitHubClient client) {
        super(client);
    }

    public List<Milestone> getMilestones(IRepositoryIdProvider repository, String state) throws IOException {
        String repoId = this.getId(repository);
        return this.getMilestones(repoId, state);
    }

    public List<Milestone> getMilestones(String user, String repository, String state) throws IOException {
        this.verifyRepository(user, repository);
        String repoId = user + '/' + repository;
        return this.getMilestones(repoId, state);
    }

    private List<Milestone> getMilestones(String id, String state) throws IOException {
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/milestones");
        PagedRequest request = this.createPagedRequest();
        if (state != null) {
            request.setParams(Collections.singletonMap("state", state));
        }
        request.setUri(uri).setType(new TypeToken<List<Milestone>>(){}.getType());
        return this.getAll(request);
    }

    public Milestone createMilestone(IRepositoryIdProvider repository, Milestone milestone) throws IOException {
        String repoId = this.getId(repository);
        return this.createMilestone(repoId, milestone);
    }

    public Milestone createMilestone(String user, String repository, Milestone milestone) throws IOException {
        this.verifyRepository(user, repository);
        String repoId = user + '/' + repository;
        return this.createMilestone(repoId, milestone);
    }

    private Milestone createMilestone(String id, Milestone milestone) throws IOException {
        if (milestone == null) {
            throw new IllegalArgumentException("Milestone cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/milestones");
        return (Milestone)this.client.post(uri.toString(), milestone, (Type)((Object)Milestone.class));
    }

    public Milestone getMilestone(IRepositoryIdProvider repository, int number) throws IOException {
        return this.getMilestone(repository, Integer.toString(number));
    }

    public Milestone getMilestone(IRepositoryIdProvider repository, String number) throws IOException {
        String repoId = this.getId(repository);
        return this.getMilestone(repoId, number);
    }

    public Milestone getMilestone(String user, String repository, int number) throws IOException {
        return this.getMilestone(user, repository, Integer.toString(number));
    }

    public Milestone getMilestone(String user, String repository, String number) throws IOException {
        this.verifyRepository(user, repository);
        String repoId = user + '/' + repository;
        return this.getMilestone(repoId, number);
    }

    private Milestone getMilestone(String id, String number) throws IOException {
        if (number == null) {
            throw new IllegalArgumentException("Milestone cannot be null");
        }
        if (number.length() == 0) {
            throw new IllegalArgumentException("Milestone cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/milestones");
        uri.append('/').append(number);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)Milestone.class));
        return (Milestone)this.client.get(request).getBody();
    }

    public void deleteMilestone(IRepositoryIdProvider repository, int milestone) throws IOException {
        this.deleteMilestone(repository, Integer.toString(milestone));
    }

    public void deleteMilestone(IRepositoryIdProvider repository, String milestone) throws IOException {
        String repoId = this.getId(repository);
        this.deleteMilestone(repoId, milestone);
    }

    public void deleteMilestone(String user, String repository, int milestone) throws IOException {
        this.deleteMilestone(user, repository, Integer.toString(milestone));
    }

    public void deleteMilestone(String user, String repository, String milestone) throws IOException {
        this.verifyRepository(user, repository);
        String repoId = user + '/' + repository;
        this.deleteMilestone(repoId, milestone);
    }

    private void deleteMilestone(String id, String milestone) throws IOException {
        if (milestone == null) {
            throw new IllegalArgumentException("Milestone cannot be null");
        }
        if (milestone.length() == 0) {
            throw new IllegalArgumentException("Milestone cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/milestones");
        uri.append('/').append(milestone);
        this.client.delete(uri.toString());
    }

    public Milestone editMilestone(IRepositoryIdProvider repository, Milestone milestone) throws IOException {
        String repoId = this.getId(repository);
        if (milestone == null) {
            throw new IllegalArgumentException("Milestone cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/milestones");
        uri.append('/').append(milestone.getNumber());
        return (Milestone)this.client.post(uri.toString(), milestone, (Type)((Object)Milestone.class));
    }
}

